/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.swt.SelectionManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListViewer<E>
implements ListEventListener<E> {
    private List list = null;
    private TransformedList<E, E> swtSource = null;
    private ILabelProvider labelProvider = null;
    private SelectionManager<E> selection = null;

    public EventListViewer(EventList<E> source, List list) {
        this(source, list, (ILabelProvider)new LabelProvider());
    }

    public EventListViewer(EventList<E> source, List list, ILabelProvider labelProvider) {
        this.swtSource = GlazedListsSWT.swtThreadProxyList(source, list.getDisplay());
        this.list = list;
        this.labelProvider = labelProvider;
        this.selection = new SelectionManager(this.swtSource, new SelectableList());
        this.populateList();
        this.swtSource.addListEventListener(this);
    }

    private void populateList() {
        for (int i = 0; i < this.swtSource.size(); ++i) {
            this.addRow(i, this.swtSource.get(i));
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public List getList() {
        return this.list;
    }

    public EventList<E> getDeselected() {
        return this.selection.getSelectionList().getDeselected();
    }

    public EventList<E> getSelected() {
        return this.selection.getSelectionList().getSelected();
    }

    private void addRow(int row, Object value) {
        this.list.add(this.labelProvider.getText(value), row);
    }

    private void updateRow(int row, Object value) {
        this.list.setItem(row, this.labelProvider.getText(value));
    }

    private void deleteRow(int row) {
        this.list.remove(row);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        int firstModified = this.swtSource.size();
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.addRow(changeIndex, this.swtSource.get(changeIndex));
                firstModified = Math.min(changeIndex, firstModified);
                continue;
            }
            if (changeType == 1) {
                this.updateRow(changeIndex, this.swtSource.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            this.deleteRow(changeIndex);
            firstModified = Math.min(changeIndex, firstModified);
        }
        this.selection.fireSelectionChanged(firstModified, this.swtSource.size() - 1);
    }

    public void invertSelection() {
        this.selection.getSelectionList().invertSelection();
    }

    public void dispose() {
        this.selection.dispose();
        this.swtSource.removeListEventListener(this);
        this.swtSource.dispose();
    }

    private final class SelectableList
    implements Selectable {
        private SelectableList() {
        }

        public void addSelectionListener(SelectionListener listener) {
            EventListViewer.this.list.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            EventListViewer.this.list.removeSelectionListener(listener);
        }

        public int getSelectionIndex() {
            return EventListViewer.this.list.getSelectionIndex();
        }

        public int[] getSelectionIndices() {
            return EventListViewer.this.list.getSelectionIndices();
        }

        public int getStyle() {
            return EventListViewer.this.list.getStyle();
        }

        public void select(int index) {
            EventListViewer.this.list.select(index);
        }

        public void deselect(int index) {
            EventListViewer.this.list.deselect(index);
        }
    }
}

