/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.PropertyValues;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import com.mathworks.wizard.ui.panels.PanelBuilderImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.ui.panels.PanelStepBuilderImpl;
import com.mathworks.wizard.ui.panels.PanelStepFactory;
import com.mathworks.wizard.ui.panels.PanelStepFactoryAutomated;
import com.mathworks.wizard.ui.panels.PanelStepFactoryImpl;
import com.mathworks.wizard.ui.panels.PanelTimer;
import com.mathworks.wizard.ui.panels.PanelTimerImpl;
import com.mathworks.wizard.ui.panels.ProxyConfigurator;
import com.mathworks.wizard.ui.panels.ProxyConfiguratorImpl;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.swing.Timer;

public final class PanelsModule
extends AbstractModule {
    private static final String BASE_PANEL_STEP_FACTORY = "BasePanelStepFactory";

    protected void configure() {
        this.bind(PanelStepBuilder.class).to(PanelStepBuilderImpl.class);
        this.bind(PanelBuilder.class).to(PanelBuilderImpl.class);
        this.bind(PanelStepFactory.class).annotatedWith((Annotation)Names.named((String)BASE_PANEL_STEP_FACTORY)).to(PanelStepFactoryImpl.class).in(Scopes.SINGLETON);
        this.bind(FolderUtils.class).to(FolderUtilsImpl.class);
        this.bind(ProxyConfigurator.class).to(ProxyConfiguratorImpl.class);
    }

    @Provides
    @Singleton
    static PanelTimer providePanelTimer(Properties properties) {
        int n;
        try {
            String string = properties.getProperty(PropertyKey.AUTOMATED_TIMEOUT.get(), PropertyValues.DEFAULT_AUTOMODE_TIMEOUT);
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1000;
        }
        return new PanelTimerImpl(new Timer(n, null));
    }

    @Provides
    @Singleton
    static PanelStepFactory providePanelStepFactory(Properties properties, @Named(value="BasePanelStepFactory") PanelStepFactory panelStepFactory, PanelTimer panelTimer) {
        String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
        if (string.equalsIgnoreCase("automated")) {
            return new PanelStepFactoryAutomated(panelStepFactory, panelTimer);
        }
        return panelStepFactory;
    }
}

