/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.google.inject.Inject;
import com.mathworks.instutil.wizard.AbstractPanelBuilder;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.ImageResourceRetriever;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class PanelBuilderImpl
extends AbstractPanelBuilder<PanelBuilder>
implements PanelBuilder {
    private final SwingComponentFactory factory;
    private final ResourceRetriever resourceRetriever;
    private final HyperlinkProvider hyperlinkProvider;

    @Inject
    PanelBuilderImpl(SwingComponentFactory swingComponentFactory, ResourceRetriever resourceRetriever, HyperlinkProvider hyperlinkProvider) {
        this.factory = swingComponentFactory;
        this.resourceRetriever = resourceRetriever;
        this.hyperlinkProvider = hyperlinkProvider;
    }

    protected PanelBuilder getThis() {
        return this;
    }

    protected JPanel createPanel(LayoutManager layoutManager) {
        return this.factory.createPanel(layoutManager);
    }

    protected JComponent createPrivacyPolicyLabel() {
        return this.factory.createLabel(WizardResourceKeys.LABEL_PRIVACYPOLICY.getString(this.hyperlinkProvider.getPrivacyPolicyLink()), WizardComponentName.LABEL_PRIVACYPOLICY);
    }

    protected JPanel createBackgroundPanel() {
        return this.factory.createBackgroundPanel();
    }

    protected JComponent createMainImage() {
        ImageIcon imageIcon = this.resourceRetriever.getImage(ImageResourceRetriever.MAIN_IMAGE, new Object[0]);
        return this.createMainImage(imageIcon);
    }

    protected JComponent createMainImage(ImageIcon imageIcon) {
        return this.factory.createImageComponent(imageIcon);
    }
}

