/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class LinuxOptionsPanelUI
extends AbstractPanelUI {
    private final JPanel panel;
    private static final String SYM_LINK_ACCESSIBLE_NAME = "";
    private JTextComponent symLinkTextField;
    private AbstractButton symLinkCheckBox;
    private final FolderUtils folderUtils;
    private UsageDataCollector usageDataCollector;

    LinuxOptionsPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, final InstallOptionModel installOptionModel, UsageDataCollector usageDataCollector) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.OPTIONS_TITLE.getString(new Object[0]));
        this.folderUtils = folderUtils;
        this.usageDataCollector = usageDataCollector;
        this.symLinkCheckBox = swingComponentFactory.createCheckBox(WizardResourceKeys.OPTIONS_SYMLINKS_CHECKBOX.getString(new Object[0]), WizardComponentName.SYMBOLIC_LINK_CHECKBOX);
        swingComponentFactory.createAssociation(this.symLinkCheckBox, installOptionModel);
        this.symLinkTextField = swingComponentFactory.createTextField(WizardComponentName.SYMBOLIC_LINK_TEXTFIELD, SYM_LINK_ACCESSIBLE_NAME);
        swingComponentFactory.addDocumentObserver(this.symLinkTextField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                installOptionModel.setContext(LinuxOptionsPanelUI.this.getValidPath());
            }
        });
        String string = installOptionModel.getContext();
        this.symLinkTextField.setText(string);
        JComponent jComponent = swingComponentFactory.createBrowseableFolderTextField(this.symLinkTextField, WizardComponentName.SYMBOLIC_LINK_BROWSE_BUTTON, string);
        swingComponentFactory.createRelationship(this.symLinkCheckBox, jComponent.getComponents());
        this.panel = ((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{this.symLinkCheckBox})).addRow(new JComponent[]{jComponent})).buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return jComponent;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.OPTIONS_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
        this.symLinkCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(LinuxOptionsPanelUI.this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
            }
        });
        this.factory.addDocumentObserver(this.symLinkTextField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LinuxOptionsPanelUI.this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
            }
        });
    }

    private boolean checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty() {
        return !this.symLinkCheckBox.isSelected() || this.getValidPath().length() > 0;
    }

    private String getValidPath() {
        return this.folderUtils.scrub(this.symLinkTextField.getText());
    }

    @Override
    public boolean apply() {
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_SYMBOLIC_LINKS_SELECTED, (Object)this.symLinkCheckBox.isSelected());
        return true;
    }
}

