/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.licensefiles.LicenseFileExt;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

final class LicenseFilePanelUI
extends AbstractPanelUI {
    private Model<String> licenseFilePath;
    private JTextComponent licenseFileTextField;
    private FolderUtils folderUtils;
    private JPanel panel;

    LicenseFilePanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, Model<String> model) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.LICENSE_FILE_TITLE.getString(new Object[0]));
        this.licenseFilePath = model;
        this.folderUtils = folderUtils;
        JComponent jComponent = swingComponentFactory.createLabel(resourceBundle.getString(WizardResourceKeys.LICENSE_FILE_BOLD_LABEL.getKey()), WizardComponentName.LICENSE_FILE_BOLD_LABEL);
        JComponent jComponent2 = swingComponentFactory.createLabel(resourceBundle.getString(WizardResourceKeys.LICENSE_FILE_FIELD_LABEL.getKey()), WizardComponentName.LICENSE_FILE_FIELD_LABEL);
        this.licenseFileTextField = swingComponentFactory.createTextField(WizardComponentName.LICENSE_FILE_FIELD, resourceBundle.getString(WizardResourceKeys.LICENSE_FILE_FIELD_LABEL.getKey()));
        this.licenseFileTextField.setText(this.licenseFilePath.get());
        JComponent jComponent3 = swingComponentFactory.createBrowseableFileTextField(this.licenseFileTextField, WizardComponentName.LICENSE_FILE_BROWSE_BUTTON, WizardResourceKeys.LICENSE_FILE_BROWSE_TITLE.getString(new Object[0]), new LicenseFileFilter());
        JComponent jComponent4 = swingComponentFactory.createLabel(resourceBundle.getString(WizardResourceKeys.LICENSE_FILE_FIELD_DESCRIPTION.getKey()), WizardComponentName.LICENSE_FILE_FIELD_DESCRIPTION);
        this.panel = ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jComponent2})).addRow(new JComponent[]{jComponent3})).addRow(new JComponent[]{jComponent4})).buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.licenseFileTextField;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.LICENSE_FILE_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public boolean apply() {
        this.licenseFilePath.set(this.getPath());
        return true;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.getPath().length() > 0);
        this.factory.addDocumentObserver(this.licenseFileTextField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LicenseFilePanelUI.this.getPath().length() > 0);
            }
        });
    }

    private String getPath() {
        return this.folderUtils.scrub(this.licenseFileTextField.getText());
    }

    private static class LicenseFileFilter
    extends FileFilter {
        private LicenseFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isFile()) {
                for (LicenseFileExt licenseFileExt : LicenseFileExt.values()) {
                    if (!file.getName().toLowerCase().endsWith(licenseFileExt.getExt())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            LicenseFileExt[] licenseFileExtArray = LicenseFileExt.values();
            for (int i = 0; i < licenseFileExtArray.length; ++i) {
                stringBuilder.append("*");
                stringBuilder.append(licenseFileExtArray[i]);
                if (i >= licenseFileExtArray.length - 1) continue;
                stringBuilder.append("; ");
            }
            return WizardResourceKeys.LICENSE_FILE_BROWSE_FILTER.getString(stringBuilder.toString());
        }
    }
}

