/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import com.mathworks.instutil.DisplayProperties;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.wizard.Desktop;
import com.mathworks.instutil.wizard.DesktopImpl;
import com.mathworks.instutil.wizard.HyperlinkHandler;
import com.mathworks.instutil.wizard.JEditorPaneHyperlinkHandler;
import com.mathworks.instutil.wizard.SelectAllOnFocusListener;
import com.mathworks.instutil.wizard.TextComponentConfigurator;
import com.mathworks.instutil.wizard.TextComponentFactory;
import com.mathworks.instutil.wizard.TextComponentFactoryImpl;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.ui.components.ButtonStrategy;
import com.mathworks.wizard.ui.components.ButtonStrategyAutomated;
import com.mathworks.wizard.ui.components.DefaultButtonStrategy;
import com.mathworks.wizard.ui.components.DefaultJFrameDisplayStrategy;
import com.mathworks.wizard.ui.components.DefaultPaintStrategy;
import com.mathworks.wizard.ui.components.FileBrowseStrategy;
import com.mathworks.wizard.ui.components.FileBrowseStrategyDefault;
import com.mathworks.wizard.ui.components.HighContrastPaintStrategy;
import com.mathworks.wizard.ui.components.JFrameDisplayStrategy;
import com.mathworks.wizard.ui.components.MacButtonStrategy;
import com.mathworks.wizard.ui.components.PaintStrategy;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.components.SwingComponentFactoryImpl;
import com.mathworks.wizard.ui.components.WindowsJFrameDisplayStrategy;
import com.mathworks.wizard.ui.panels.PanelTimer;
import java.util.Properties;
import javax.swing.JFrame;

public final class ComponentsModule
extends AbstractModule {
    private static final String BASE_BUTTON_STRATEGY = "BaseButtonStrategy";

    protected void configure() {
        this.bind(SwingComponentFactory.class).to(SwingComponentFactoryImpl.class);
        this.bind(HyperlinkHandler.class).to(JEditorPaneHyperlinkHandler.class);
        this.bind(Desktop.class).to(DesktopImpl.class).in(Scopes.SINGLETON);
    }

    @Provides
    static TextComponentFactory provideTextComponentFactory(ExceptionHandler exceptionHandler, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior) {
        return new TextComponentFactoryImpl((com.mathworks.instutil.wizard.ExceptionHandler)exceptionHandler, selectAllBehavior);
    }

    @Provides
    static TextComponentConfigurator provideTextComponentConfigurator(ExceptionHandler exceptionHandler, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior) {
        return new TextComponentFactoryImpl((com.mathworks.instutil.wizard.ExceptionHandler)exceptionHandler, selectAllBehavior);
    }

    @Provides
    @Named(value="BaseButtonStrategy")
    static ButtonStrategy provideButtonStrategy(Platform platform) {
        if (platform.isMac()) {
            return new MacButtonStrategy();
        }
        return new DefaultButtonStrategy();
    }

    @Provides
    static ButtonStrategy provideButtonStrategy(@Named(value="BaseButtonStrategy") ButtonStrategy buttonStrategy, Properties properties, PanelTimer panelTimer) {
        String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
        if (string.equalsIgnoreCase("automated")) {
            return new ButtonStrategyAutomated(buttonStrategy, panelTimer);
        }
        return buttonStrategy;
    }

    @Provides
    static PaintStrategy providePaintStrategy(DisplayProperties displayProperties) {
        return displayProperties.isHighContrast() ? new HighContrastPaintStrategy() : new DefaultPaintStrategy();
    }

    @Provides
    static SelectAllOnFocusListener.SelectAllBehavior provideSelectAllBehavior(Platform platform) {
        if (platform.isWindows()) {
            return SelectAllOnFocusListener.SelectAllBehavior.ALWAYS;
        }
        return SelectAllOnFocusListener.SelectAllBehavior.KEYBOARD;
    }

    @Provides
    static FileBrowseStrategy provideFileBrowseStrategy(Platform platform, JFrame jFrame, FolderUtils folderUtils) {
        return new FileBrowseStrategyDefault(jFrame, folderUtils);
    }

    @Provides
    static JFrameDisplayStrategy provideJFrameDisplayStrategy(Platform platform) {
        return platform.isWindows() ? new WindowsJFrameDisplayStrategy() : new DefaultJFrameDisplayStrategy();
    }
}

