/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui;

import com.google.inject.Inject;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.wizard.EscapeHandler;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.ComponentName;
import com.mathworks.wizard.ui.FocusTraversalPolicyImpl;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.ProgressDialogSemaphore;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.JFrameDisplayStrategy;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.laf.UIProperties;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

final class WizardUIImpl
implements WizardUI {
    private final SwingComponentFactory swingComponentFactory;
    private final EscapeHandler escapeHandler;
    private final JFrame frame;
    private final UIProperties uiProperties;
    private final ProgressDialogSemaphore progressDialogSemaphore;
    private final AppLogger appLogger;
    private final ResourceRetriever resourceRetriever;
    private final JFrameDisplayStrategy frameDisplayStrategy;
    private JPanel rootPanel;
    private Container contentContainer;
    private Container navigationContainer;
    private Command cancelCmd;
    private JDialog progressDialog;
    private Component glassPane;

    @Inject
    WizardUIImpl(final JFrame jFrame, SwingComponentFactory swingComponentFactory, final EscapeHandler escapeHandler, UIProperties uIProperties, ProgressDialogSemaphore progressDialogSemaphore, ResourceRetriever resourceRetriever, AppLogger appLogger, JFrameDisplayStrategy jFrameDisplayStrategy) {
        this.frame = jFrame;
        this.swingComponentFactory = swingComponentFactory;
        this.escapeHandler = escapeHandler;
        this.uiProperties = uIProperties;
        this.progressDialogSemaphore = progressDialogSemaphore;
        this.resourceRetriever = resourceRetriever;
        this.appLogger = appLogger;
        this.frameDisplayStrategy = jFrameDisplayStrategy;
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.uiProperties.initialize();
                WizardUIImpl.this.rootPanel = WizardUIImpl.this.swingComponentFactory.createPanel();
                WizardUIImpl.this.glassPane = ((RootPaneContainer)((Object)jFrame.getRootPane().getTopLevelAncestor())).getGlassPane();
                WizardUIImpl.this.contentContainer = WizardUIImpl.this.swingComponentFactory.createPanel(new CardLayout());
                WizardUIImpl.this.rootPanel.add((Component)WizardUIImpl.this.contentContainer, "Center");
                WizardUIImpl.this.navigationContainer = WizardUIImpl.this.swingComponentFactory.createPanel(new CardLayout());
                WizardUIImpl.this.rootPanel.add((Component)WizardUIImpl.this.navigationContainer, "South");
                WizardUIImpl.this.cancelCmd = new Command(){

                    @Override
                    public void execute() {
                    }
                };
                WizardUIImpl.this.setUpFrame(escapeHandler);
                WizardUIImpl.this.setUpIcon();
                WizardUIImpl.this.sizeAndPosition();
            }
        });
    }

    private static void addPanelToLayoutAndContainerIfNeeded(JPanel jPanel, String string, CardLayout cardLayout, Container container) {
        boolean bl = WizardUIImpl.isPanelInContainer(jPanel, container);
        if (!bl) {
            WizardUIImpl.addPanelToLayoutAndContainer(jPanel, string, cardLayout, container);
        }
    }

    private static boolean isPanelInContainer(JPanel jPanel, Container container) {
        List<Component> list = Arrays.asList(container.getComponents());
        return list.contains(jPanel);
    }

    private static void addPanelToLayoutAndContainer(JPanel jPanel, String string, CardLayout cardLayout, Container container) {
        cardLayout.addLayoutComponent(jPanel, string);
        container.add((Component)jPanel, string);
    }

    private static String getNonHTMLAccessibleName(String string) {
        return string.replaceAll("<.*?>", "");
    }

    private static Response getResponse(JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (object == null || object.equals(-1) || !(object instanceof Response)) {
            return Response.CANCEL;
        }
        return (Response)((Object)object);
    }

    private void setUpFrame(EscapeHandler escapeHandler) {
        this.frame.pack();
        this.frame.setDefaultCloseOperation(0);
        this.setUpEscapeKey(escapeHandler);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WizardUIImpl.this.cancelCmd.execute();
            }
        });
        this.frame.setFocusTraversalPolicy(new FocusTraversalPolicyImpl());
        this.frame.setName(WizardComponentName.WIZARD_FRAME.toString());
    }

    private void setUpEscapeKey(EscapeHandler escapeHandler) {
        escapeHandler.setUpEscapeKey((RootPaneContainer)this.frame, (Window)this.frame);
    }

    private void setContentPanel(JPanel jPanel, String string) {
        Container container = this.contentContainer;
        CardLayout cardLayout = (CardLayout)container.getLayout();
        WizardUIImpl.addPanelToLayoutAndContainerIfNeeded(jPanel, string, cardLayout, container);
        cardLayout.show(container, string);
    }

    private void setNavigationPanel(JPanel jPanel, JButton jButton) {
        Container container = this.navigationContainer;
        container.removeAll();
        CardLayout cardLayout = new CardLayout();
        container.setLayout(cardLayout);
        WizardUIImpl.addPanelToLayoutAndContainer(jPanel, "Navigation Panel", cardLayout, container);
        cardLayout.show(container, "Navigation Panel");
        this.frame.getRootPane().setDefaultButton(jButton);
    }

    private void setAccessibleName(String string) {
        AccessibleContext accessibleContext = this.frame.getAccessibleContext();
        accessibleContext.setAccessibleName(string);
    }

    private void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    @Override
    public void closeAndDispose() {
        this.hideBusyCursor();
        this.setVisible(false);
        this.uiProperties.undo();
        this.frame.dispose();
    }

    @Override
    public void showProgress(String string, String string2, final Command command) {
        this.progressDialog = this.swingComponentFactory.createProgressDialog(this.frame, string, string2, WizardComponentName.PROGRESS_TEXT_PANE);
        this.progressDialog.setName(WizardComponentName.PROGRESS_DIALOG.toString());
        this.progressDialog.setDefaultCloseOperation(0);
        this.progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                command.execute();
            }
        });
        this.escapeHandler.setUpEscapeKey((RootPaneContainer)this.progressDialog, (Window)this.progressDialog);
        int n = this.getDPIFriendlySize(250);
        int n2 = this.getDPIFriendlySize(150);
        this.progressDialog.setSize(n, n2);
        try {
            this.progressDialogSemaphore.acquire();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.showDialogLater(this.progressDialog);
    }

    @Override
    public void showBusyCursor(final Command command) {
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.glassPane.setVisible(true);
        this.glassPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getChanged() == WizardUIImpl.this.glassPane && ((hierarchyEvent.getChangeFlags() ^ 0xFFFFFFFFFFFFFFFFL) & 4L) == 0L) {
                    WizardUIImpl.this.glassPane.removeHierarchyListener(this);
                    command.execute();
                }
            }
        });
    }

    @Override
    public void hideBusyCursor() {
        this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
        this.glassPane.setVisible(false);
    }

    @Override
    public void hideProgress() {
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.hideProgressOnCurrentThread();
            }
        });
    }

    private void hideProgressOnCurrentThread() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
            this.progressDialogSemaphore.release();
        }
    }

    @Override
    public void showInfoMessage(String string, Component component) {
        this.appLogger.logMsg("Info: " + component);
        this.showMessageOnEDT(string, component, MessageType.INFORMATION, OptionType.DEFAULT, (ComponentName)WizardComponentName.INFORMATION_TEXT_PANE, WizardComponentName.INFORMATION_DIALOG);
    }

    @Override
    public boolean showPlainMessage(String string, Component component) {
        Response response = this.showMessageOnEDT(string, component, MessageType.PLAIN, OptionType.OK_CANCEL, (ComponentName)WizardComponentName.PROXY_TEXT_PANE, WizardComponentName.PROXY_DIALOG);
        return Response.OK.equals((Object)response);
    }

    @Override
    public void showPanel(final JPanel jPanel, final String string, final JPanel jPanel2, final JButton jButton, final Command command, final String string2, final String string3) {
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.setContentPanel(jPanel, string);
                WizardUIImpl.this.setNavigationPanel(jPanel2, jButton);
                WizardUIImpl.this.setCancelCommand(command);
                WizardUIImpl.this.setTitle(string2);
                WizardUIImpl.this.setAccessibleName(WizardUIImpl.getNonHTMLAccessibleName(string3));
                boolean bl = WizardUIImpl.this.frame.isVisible();
                WizardUIImpl.this.setVisible(true);
                if (!bl) {
                    WizardUIImpl.this.frameDisplayStrategy.activateJFrame(WizardUIImpl.this.frame);
                }
            }
        });
    }

    @Override
    public boolean showMessageWithoutHidingProgressDialog(final String string, final Component component) {
        final ModelImpl modelImpl = new ModelImpl();
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = WizardUIImpl.this.swingComponentFactory.createOptionPane(component, MessageType.PLAIN, OptionType.OK_CANCEL, (ComponentName)WizardComponentName.PROXY_TEXT_PANE);
                JDialog jDialog = WizardUIImpl.this.createOptionPaneDialog(string, jOptionPane, WizardComponentName.PROXY_DIALOG);
                WizardUIImpl.this.showDialogOnCurrentThread(jDialog);
                modelImpl.set(WizardUIImpl.getResponse(jOptionPane));
            }
        });
        return Response.OK.equals(modelImpl.get());
    }

    @Override
    public void showErrorMessage(String string, String string2) {
        this.appLogger.logMsg("Error: " + string2);
        this.showMessageOnEDT(string, string2, MessageType.ERROR, OptionType.DEFAULT, (ComponentName)WizardComponentName.ERROR_TEXT_PANE, WizardComponentName.ERROR_DIALOG);
    }

    @Override
    public boolean showWarningMessage(String string, String string2) {
        this.appLogger.logMsg("Warning: " + string2);
        Response response = this.showMessageOnEDT(string, string2, MessageType.WARNING, OptionType.DEFAULT, (ComponentName)WizardComponentName.WARNING_TEXT_PANE, WizardComponentName.WARNING_DIALOG);
        return Response.OK.equals((Object)response);
    }

    private Response showMessageOnEDT(final String string, final String string2, final MessageType messageType, final OptionType optionType, final ComponentName componentName, final WizardComponentName wizardComponentName) {
        final ModelImpl modelImpl = new ModelImpl();
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = WizardUIImpl.this.swingComponentFactory.createOptionPane(string2, messageType, optionType, componentName);
                WizardUIImpl.this.showOptionPaneOnCurrentThread(string, jOptionPane, wizardComponentName);
                modelImpl.set(WizardUIImpl.getResponse(jOptionPane));
            }
        });
        return (Response)((Object)modelImpl.get());
    }

    private void showOptionPaneOnCurrentThread(String string, JOptionPane jOptionPane, WizardComponentName wizardComponentName) {
        this.hideProgressOnCurrentThread();
        JDialog jDialog = this.createOptionPaneDialog(string, jOptionPane, wizardComponentName);
        this.showDialogOnCurrentThread(jDialog);
    }

    private Response showMessageOnEDT(final String string, final Component component, final MessageType messageType, final OptionType optionType, final ComponentName componentName, final WizardComponentName wizardComponentName) {
        final ModelImpl modelImpl = new ModelImpl();
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = WizardUIImpl.this.swingComponentFactory.createOptionPane(component, messageType, optionType, componentName);
                WizardUIImpl.this.showOptionPaneOnCurrentThread(string, jOptionPane, wizardComponentName);
                modelImpl.set(WizardUIImpl.getResponse(jOptionPane));
            }
        });
        return (Response)((Object)modelImpl.get());
    }

    private void showDialogOnCurrentThread(JDialog jDialog) {
        if (this.frame.getState() == 1) {
            jDialog.setLocationRelativeTo(null);
        } else {
            jDialog.setLocationRelativeTo(this.frame);
        }
        jDialog.setModal(true);
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    private void showDialogLater(final JDialog jDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.showDialogOnCurrentThread(jDialog);
            }
        });
    }

    private JDialog createOptionPaneDialog(String string, JOptionPane jOptionPane, WizardComponentName wizardComponentName) {
        JDialog jDialog = jOptionPane.createDialog(this.frame, string);
        jDialog.setName(wizardComponentName.toString());
        jDialog.setResizable(true);
        JScrollPane jScrollPane = new JScrollPane(jOptionPane);
        jScrollPane.setBorder(null);
        jDialog.setContentPane(jScrollPane);
        jDialog.pack();
        jDialog.setFocusTraversalPolicy(new FocusTraversalPolicyImpl());
        return jDialog;
    }

    @Override
    public boolean getResponseToYesNoQuestion(String string, String string2, MessageType messageType) {
        Response response = this.getResponseToQuestion(string, string2, messageType, OptionType.YES_NO);
        return response.equals((Object)Response.YES);
    }

    @Override
    public Response getResponseToQuestion(String string, String string2, MessageType messageType, OptionType optionType) {
        this.appLogger.logMsg(string2);
        return this.showMessageOnEDT(string, string2, messageType, optionType, (ComponentName)WizardComponentName.QUESTION_TEXT_PANE, WizardComponentName.QUESTION_DIALOG);
    }

    @Override
    public void setTitle(final String string) {
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.frame.setTitle(string);
            }
        });
    }

    private void setCancelCommand(Command command) {
        this.cancelCmd = command;
    }

    private void setUpIcon() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(this.resourceRetriever.getIcon(WizardResourceKeys.ICON_16, new Object[0]).getImage());
        arrayList.add(this.resourceRetriever.getIcon(WizardResourceKeys.ICON_32, new Object[0]).getImage());
        arrayList.add(this.resourceRetriever.getIcon(WizardResourceKeys.ICON_48, new Object[0]).getImage());
        this.setIconImages(arrayList);
    }

    @Override
    public void setIconImages(final List<Image> list) {
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                WizardUIImpl.this.frame.setIconImages(list);
            }
        });
    }

    private void sizeAndPosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        Insets insets = this.frame.getInsets();
        int n3 = this.getFrameWidth(insets);
        int n4 = this.getFrameHeight(insets);
        if (n < n4) {
            n4 = n;
        }
        if (n2 < n3) {
            n3 = n2;
        }
        JScrollPane jScrollPane = new JScrollPane(this.rootPanel);
        jScrollPane.setBorder(null);
        this.frame.add((Component)jScrollPane, "Center");
        Dimension dimension2 = new Dimension(n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
        this.rootPanel.setPreferredSize(dimension2);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    private int getFrameWidth(Insets insets) {
        return this.getDPIFriendlySize(635) + insets.left + insets.right;
    }

    private int getFrameHeight(Insets insets) {
        return this.getDPIFriendlySize(375) + insets.top + insets.bottom - 23;
    }

    private int getDPIFriendlySize(int n) {
        float f = this.rootPanel.getFont().getSize2D() / 11.0f;
        Float f2 = Float.valueOf((float)n * f);
        return f2.intValue();
    }
}

