/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.wizard.DefaultPrinter;
import com.mathworks.instutil.wizard.EscapeHandler;
import com.mathworks.instutil.wizard.EscapeHandlerImpl;
import com.mathworks.instutil.wizard.Printer;
import com.mathworks.webproxy.ProxyAuthenticationUI;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.ui.ProgressDialogSemaphore;
import com.mathworks.wizard.ui.ProgressDialogSemaphoreImpl;
import com.mathworks.wizard.ui.WizardProxyAuthenticationUI;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.WizardUIAutomated;
import com.mathworks.wizard.ui.WizardUIImpl;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.swing.JFrame;

public final class UIModule
extends AbstractModule {
    static final String BASE_WIZARD_UI = "BaseWizardUI";
    static final String AUTO_WIZARD_UI = "AutoWizardUI";

    protected void configure() {
        this.bind(WizardUI.class).annotatedWith((Annotation)Names.named((String)AUTO_WIZARD_UI)).to(WizardUIAutomated.class).in(Scopes.SINGLETON);
        this.bind(WizardUI.class).annotatedWith((Annotation)Names.named((String)BASE_WIZARD_UI)).to(WizardUIImpl.class).in(Scopes.SINGLETON);
        this.bind(EscapeHandler.class).to(EscapeHandlerImpl.class);
        this.bind(ProgressDialogSemaphore.class).to(ProgressDialogSemaphoreImpl.class);
    }

    @Provides
    @Singleton
    static JFrame provideJFrame() {
        return new JFrame();
    }

    @Provides
    @Singleton
    static WizardUI provideWizardUI(Properties properties, @Named(value="BaseWizardUI") WizardUI wizardUI, @Named(value="AutoWizardUI") WizardUI wizardUI2, AppLogger appLogger) {
        String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
        if (string.equalsIgnoreCase("automated")) {
            return wizardUI2;
        }
        return wizardUI;
    }

    @Provides
    static Printer providePrinter(ExceptionHandler exceptionHandler) {
        return new DefaultPrinter((com.mathworks.instutil.wizard.ExceptionHandler)exceptionHandler);
    }

    @Provides
    static ProxyAuthenticationUI provideProxyAuthenticationUI(WizardUI wizardUI, SwingComponentFactory swingComponentFactory) {
        return new WizardProxyAuthenticationUI(wizardUI, swingComponentFactory);
    }
}

