/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.args.ArgumentsUtility;
import com.mathworks.instutil.args.ArgumentsUtilityFactory;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.ArgumentLoggingFilterImpl;
import com.mathworks.instutil.logging.LoggingFilterStrategy;
import com.mathworks.instutil.logging.SensitiveInformationLoggingFilterStrategyImpl;
import com.mathworks.webproxy.ProxyAuthenticationUI;
import com.mathworks.webproxy.ProxyAuthenticator;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.LoggerModule;
import com.mathworks.wizard.PropertiesModule;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepSequencer;
import com.mathworks.wizard.WizardFactory;
import com.mathworks.wizard.WizardModule;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.UIModule;
import com.mathworks.wizard.ui.components.ComponentsModule;
import com.mathworks.wizard.ui.help.HelpModule;
import com.mathworks.wizard.ui.laf.LookAndFeelModule;
import com.mathworks.wizard.ui.navigation.NavigationModule;
import com.mathworks.wizard.ui.panels.PanelsModule;
import com.mathworks.wizard.ui.silent.SilentModule;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

final class WizardLauncher {
    private WizardLauncher() {
    }

    static ExitHandler start(String[] stringArray, Module module, Module ... moduleArray) {
        String[] stringArray2;
        AppLogger appLogger = WizardLauncher.getLogger();
        Properties properties = WizardLauncher.getProperties(appLogger, stringArray2 = WizardLauncher.addDownloadAgentArguments(stringArray, appLogger), module);
        String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
        if (string.equalsIgnoreCase("silent")) {
            Boolean bl = Boolean.parseBoolean(properties.getProperty("bat", "false"));
            if (!bl.booleanValue()) {
                System.setProperty("java.awt.headless", "true");
            }
            return WizardLauncher.startSilentWizard(appLogger, properties, moduleArray);
        }
        if (GraphicsEnvironment.isHeadless()) {
            return WizardLauncher.printDisplayErrorAndExit();
        }
        return WizardLauncher.startWizard(appLogger, properties, moduleArray);
    }

    private static String[] addDownloadAgentArguments(String[] stringArray, AppLogger appLogger) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        try {
            List list;
            InstUtilResourceBundle instUtilResourceBundle = new InstUtilResourceBundle(){

                public String getString(String string) {
                    return ResourceBundle.getBundle("com.mathworks.instutil.resources.RES_instutil_notranslation").getString(string);
                }

                public void setExceptionHandler(InstUtilExceptionHandler instUtilExceptionHandler) {
                }
            };
            ArgumentsUtility argumentsUtility = ArgumentsUtilityFactory.createArgumentsUtility((Logger)appLogger.getLogger(), (InstUtilResourceBundle)instUtilResourceBundle);
            File file = new File(System.getProperty("user.dir"));
            String string = file.getAbsolutePath();
            if (!string.isEmpty() && (list = argumentsUtility.read(string)) != null) {
                arrayList.addAll(list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static AppLogger getLogger() {
        LoggerModule loggerModule = new LoggerModule();
        Injector injector = Guice.createInjector((Module[])new Module[]{loggerModule});
        return (AppLogger)injector.getInstance(AppLogger.class);
    }

    private static ExitHandler startSilentWizard(AppLogger appLogger, Properties properties, Module ... moduleArray) {
        return WizardLauncher.startWizard(appLogger, properties, Modules.override((Module[])new Module[]{new SilentModule()}).with(moduleArray));
    }

    private static Properties getProperties(final AppLogger appLogger, String[] stringArray, Module module) {
        PropertiesModule propertiesModule = new PropertiesModule(stringArray);
        Injector injector = Guice.createInjector((Module[])new Module[]{propertiesModule, module, new AbstractModule(){

            protected void configure() {
                this.bind(AppLogger.class).toInstance((Object)appLogger);
            }
        }});
        return (Properties)injector.getInstance(Properties.class);
    }

    private static ExitHandler startWizard(final AppLogger appLogger, final Properties properties, Module ... moduleArray) {
        WizardLauncher.initLogger(appLogger, properties);
        Module module = Modules.combine((Module[])new Module[]{new UIModule(), new ComponentsModule(), new HelpModule(), new LookAndFeelModule(), new PanelsModule(), new NavigationModule(), new WizardModule(), new AbstractModule(){

            protected void configure() {
                this.bind(AppLogger.class).toInstance((Object)appLogger);
                this.bind(Properties.class).toInstance((Object)properties);
            }
        }});
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{module}).with(moduleArray)});
        ExceptionHandler exceptionHandler = (ExceptionHandler)injector.getInstance(ExceptionHandler.class);
        exceptionHandler.initialize();
        ProxyAuthenticator proxyAuthenticator = (ProxyAuthenticator)injector.getInstance(ProxyAuthenticator.class);
        proxyAuthenticator.setAsDefault((ProxyConfiguration)injector.getInstance(ProxyConfiguration.class), (ProxyAuthenticationUI)injector.getInstance(ProxyAuthenticationUI.class));
        WizardFactory wizardFactory = (WizardFactory)injector.getInstance(WizardFactory.class);
        Workflow workflow = (Workflow)injector.getInstance(Workflow.class);
        final List<Step> list = wizardFactory.createWorkflowSteps(workflow);
        final StepSequencer stepSequencer = wizardFactory.createStepSequencer();
        ExitHandler exitHandler = (ExitHandler)injector.getInstance(ExitHandler.class);
        UsageDataCollector usageDataCollector = (UsageDataCollector)injector.getInstance(UsageDataCollector.class);
        WizardLauncher.collectUserArguments(usageDataCollector, properties);
        UdcUtil.collectBasicSessionInfo((UsageDataCollector)usageDataCollector);
        UdcUtil.collectOsInfo((UsageDataCollector)usageDataCollector, (ExecutorService)((ExecutorService)injector.getInstance(ExecutorService.class)));
        SecurityOverride securityOverride = (SecurityOverride)injector.getInstance(SecurityOverride.class);
        boolean bl = securityOverride.adminPrompt();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    stepSequencer.startSequence(list.toArray(new Step[list.size()]));
                }
            });
        } else {
            exitHandler.exit(ExitStatus.FAILED);
        }
        exceptionHandler.exit();
        return exitHandler;
    }

    protected static void collectUserArguments(UsageDataCollector usageDataCollector, Properties properties) {
        SensitiveInformationLoggingFilterStrategyImpl sensitiveInformationLoggingFilterStrategyImpl = new SensitiveInformationLoggingFilterStrategyImpl();
        ArgumentLoggingFilterImpl argumentLoggingFilterImpl = new ArgumentLoggingFilterImpl((LoggingFilterStrategy)sensitiveInformationLoggingFilterStrategyImpl);
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            if (!argumentLoggingFilterImpl.shouldLog(string)) continue;
            stringBuilder.append(string);
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                stringBuilder.append(" ").append(string2);
            }
            stringBuilder.append(" ");
        }
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_COMMAND_LINE_ARGUMENTS, (Object)stringBuilder.toString().trim());
    }

    private static ExitHandler printDisplayErrorAndExit() {
        System.out.println(WizardResourceKeys.DISPLAY_ERROR.getString(new Object[0]));
        return new ExitHandler(){

            @Override
            public void exit(ExitStatus exitStatus) {
            }

            @Override
            public ExitStatus waitFor() {
                return ExitStatus.FAILED;
            }
        };
    }

    private static void initLogger(AppLogger appLogger, Properties properties) {
        WizardLauncher.enableConsoleLogging(appLogger, properties);
        WizardLauncher.enableFileLogging(appLogger, properties);
        WizardLauncher.setLogLevel(appLogger, properties);
        WizardLauncher.printPreviouslyLoggedMessages(appLogger);
        WizardLauncher.printInputFileContentsToLog(appLogger, properties);
    }

    private static void enableConsoleLogging(AppLogger appLogger, Properties properties) {
        String string = PropertyKey.CONSOLE_LOG.get();
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            if (Boolean.parseBoolean(string2)) {
                appLogger.enableConsoleLogging();
            }
        } else {
            String string3 = properties.getProperty(PropertyKey.MODE.get(), "interactive");
            if ("silent".equalsIgnoreCase(string3)) {
                appLogger.enableConsoleLogging();
            }
        }
    }

    private static void printPreviouslyLoggedMessages(AppLogger appLogger) {
        appLogger.dumpStoredMessages();
    }

    private static void enableFileLogging(AppLogger appLogger, Properties properties) {
        String string = WizardLauncher.getDefaultOutputLog();
        String string2 = PropertyKey.OUTPUT_FILE.getProperty(properties, string);
        FileIO fileIO = new FileIO((FilePermissions)new FilePermissionsUtil());
        try {
            String string3 = new File(string2).getAbsolutePath();
            fileIO.mkdirs(new File(string3).getParent());
            appLogger.enableFileLogging(string3);
        }
        catch (IOException iOException) {
            if (!string2.equalsIgnoreCase(string)) {
                try {
                    fileIO.mkdirs(new File(string).getParent());
                    appLogger.enableFileLogging(string);
                }
                catch (IOException iOException2) {
                    System.out.println(WizardResourceKeys.ERROR_CREATING_DEFAULT_OUTPUTFILE.getString(string, iOException2.getMessage()));
                }
            }
            System.out.println(WizardResourceKeys.ERROR_CREATING_OUTPUTFILE.getString(string2, iOException.getMessage()));
        }
    }

    private static void setLogLevel(AppLogger appLogger, Properties properties) {
        String string = properties.getProperty(PropertyKey.DEBUG.get(), "false");
        if (string.equalsIgnoreCase("true")) {
            appLogger.setLevel(Level.FINE);
        }
    }

    private static String getDefaultOutputLog() {
        String string = System.getProperty("user.name");
        String string2 = "mathworks_" + string + ".log";
        return new File(System.getProperty("java.io.tmpdir"), string2).getAbsolutePath();
    }

    private static void printInputFileContentsToLog(AppLogger appLogger, Properties properties) {
        String string = PropertyKey.INPUT_FILE.getProperty(properties);
        if (!string.isEmpty()) {
            try {
                String string2 = FileUtils.readFileToString((File)new File(string).getAbsoluteFile());
                appLogger.logMsg("Input file:" + System.getProperty("line.separator") + string2);
            }
            catch (IOException iOException) {
                appLogger.logMsg("Error reading file " + string);
                appLogger.logMsg(iOException.getMessage());
            }
        }
    }
}

