/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIOptions;
import com.mathworks.instwiz.WIOptionsDefault;
import com.mathworks.instwiz.WIOptionsFactory;
import com.mathworks.instwiz.resources.WIComponentName;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class WIOptionPaneOptionsFactory
implements WIOptionsFactory {
    private final JOptionPane fPane;
    private final ButtonFactory fFactory;

    public WIOptionPaneOptionsFactory(JOptionPane jOptionPane, ButtonFactory buttonFactory) {
        this.fPane = jOptionPane;
        this.fFactory = buttonFactory;
    }

    @Override
    public WIOptions createOptions(int n, int n2) {
        WIOptionsDefault wIOptionsDefault;
        switch (n) {
            case 97: {
                wIOptionsDefault = new OkSkipOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 98: {
                wIOptionsDefault = new YesToAllOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 94: {
                wIOptionsDefault = new YesToAllNoToAllOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 93: {
                wIOptionsDefault = new RetryIgnoreCancelOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 1: {
                wIOptionsDefault = new YesNoCancelOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 0: {
                wIOptionsDefault = new YesNoOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 2: {
                wIOptionsDefault = new OkCancelOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 88: {
                wIOptionsDefault = new ResumeRestartSkipCancelOptions(this.fPane, this.fFactory, n2);
                break;
            }
            case 87: {
                wIOptionsDefault = new RetrySkipOptions(this.fPane, this.fFactory, n2);
                break;
            }
            default: {
                wIOptionsDefault = new OkOptions(this.fPane, this.fFactory, n2);
            }
        }
        return wIOptionsDefault;
    }

    private static final class RetrySkipOptions
    extends WIOptionsDefault {
        RetrySkipOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.RETRY, new OptionPaneAction(jOptionPane, 92), WIComponentName.RETRY_BUTTON), n == 92 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.SKIP, new OptionPaneAction(jOptionPane, 96), WIComponentName.SKIP_BUTTON), n == 96);
        }
    }

    private static class ResumeRestartSkipCancelOptions
    extends WIOptionsDefault {
        ResumeRestartSkipCancelOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.RESUME, new OptionPaneAction(jOptionPane, 90), WIComponentName.RESUME_BUTTON), n == 90 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.RESTART, new OptionPaneAction(jOptionPane, 89), WIComponentName.RESTART_BUTTON), n == 89);
            this.add(buttonFactory.createButton(WIButtonProperties.SKIP, new OptionPaneAction(jOptionPane, 96), WIComponentName.SKIP_BUTTON), n == 96);
            this.addCancelButton(jOptionPane, buttonFactory, n);
        }
    }

    private static final class OkOptions
    extends WIOptionsDefault {
        OkOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.OK, new OptionPaneAction(jOptionPane, 0), WIComponentName.OK_BUTTON), n == 0 || n == -1);
        }
    }

    private static final class YesNoOptions
    extends WIOptionsDefault {
        YesNoOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.YES, new OptionPaneAction(jOptionPane, 0), WIComponentName.YES_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.NO, new OptionPaneAction(jOptionPane, 1), WIComponentName.NO_BUTTON), n == 1);
        }
    }

    private static final class OkCancelOptions
    extends WIOptionsDefault {
        OkCancelOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.OK, new OptionPaneAction(jOptionPane, 0), WIComponentName.OK_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.CANCEL, new OptionPaneAction(jOptionPane, 2), WIComponentName.CANCEL_BUTTON), n == 2);
        }
    }

    private static final class YesNoCancelOptions
    extends WIOptionsDefault {
        YesNoCancelOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.YES, new OptionPaneAction(jOptionPane, 0), WIComponentName.YES_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.NO, new OptionPaneAction(jOptionPane, 1), WIComponentName.NO_BUTTON), n == 1);
            this.add(buttonFactory.createButton(WIButtonProperties.CANCEL, new OptionPaneAction(jOptionPane, 2), WIComponentName.CANCEL_BUTTON), n == 2);
        }
    }

    private static final class RetryIgnoreCancelOptions
    extends WIOptionsDefault {
        RetryIgnoreCancelOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.RETRY, new OptionPaneAction(jOptionPane, 92), WIComponentName.RETRY_BUTTON), n == 92 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.IGNORE, new OptionPaneAction(jOptionPane, 91), WIComponentName.IGNORE_BUTTON), n == 91);
            this.add(buttonFactory.createButton(WIButtonProperties.CANCEL, new OptionPaneAction(jOptionPane, 2), WIComponentName.CANCEL_BUTTON), n == 2);
        }
    }

    private static final class YesToAllNoToAllOptions
    extends WIOptionsDefault {
        YesToAllNoToAllOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.YES, new OptionPaneAction(jOptionPane, 0), WIComponentName.YES_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.YESTOALL, new OptionPaneAction(jOptionPane, 98), WIComponentName.YES_TO_ALL_BUTTON), n == 98);
            this.add(buttonFactory.createButton(WIButtonProperties.NO, new OptionPaneAction(jOptionPane, 1), WIComponentName.NO_BUTTON), n == 1);
            this.add(buttonFactory.createButton(WIButtonProperties.NOTOALL, new OptionPaneAction(jOptionPane, 95), WIComponentName.NO_TO_ALL_BUTTON), n == 95);
            this.add(buttonFactory.createButton(WIButtonProperties.CANCEL, new OptionPaneAction(jOptionPane, 2), WIComponentName.CANCEL_BUTTON), n == 2);
        }
    }

    private static final class YesToAllOptions
    extends WIOptionsDefault {
        public YesToAllOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.YES, new OptionPaneAction(jOptionPane, 0), WIComponentName.YES_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.YESTOALL, new OptionPaneAction(jOptionPane, 98), WIComponentName.YES_TO_ALL_BUTTON), n == 98);
            this.add(buttonFactory.createButton(WIButtonProperties.NO, new OptionPaneAction(jOptionPane, 1), WIComponentName.NO_BUTTON), n == 1);
            this.add(buttonFactory.createButton(WIButtonProperties.CANCEL, new OptionPaneAction(jOptionPane, 2), WIComponentName.CANCEL_BUTTON), n == 2);
        }
    }

    private static final class OkSkipOptions
    extends WIOptionsDefault {
        public OkSkipOptions(JOptionPane jOptionPane, ButtonFactory buttonFactory, int n) {
            this.add(buttonFactory.createButton(WIButtonProperties.OK, new OptionPaneAction(jOptionPane, 0), WIComponentName.OK_BUTTON), n == 0 || n == -1);
            this.add(buttonFactory.createButton(WIButtonProperties.SKIP, new OptionPaneAction(jOptionPane, 96), WIComponentName.SKIP_BUTTON), n == 96);
        }
    }

    private static final class OptionPaneAction
    extends AbstractAction {
        private final JOptionPane fPane;
        private final int fValue;

        public OptionPaneAction(JOptionPane jOptionPane, int n) {
            this.fPane = jOptionPane;
            this.fValue = n;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.fPane.setValue(this.fValue);
        }
    }
}

