/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WIEditorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class WIMultilineControlButton<T extends AbstractButton>
extends JPanel {
    protected JTextComponent fLabel;
    protected final MouseListener fMouseListener;
    protected final KeyListener fKeyListener = this.createKeyListener();
    private final T fButton;
    private final String controlName;

    public WIMultilineControlButton(InstWizardIntf instWizardIntf, String string, T t, String string2) {
        this.fLabel = this.createLabel(instWizardIntf, string);
        this.fMouseListener = this.createMouseListener();
        this.fButton = t;
        ((AbstractButton)this.fButton).setText("");
        ((JComponent)this.fButton).setOpaque(false);
        this.controlName = string2;
        ((Component)this.fButton).addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WIMultilineControlButton.this.fLabel.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WIMultilineControlButton.this.fLabel.repaint();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fButton, gridBagConstraints);
        this.layOutLabel();
    }

    protected MouseListener createMouseListener() {
        return new BasicButtonListener((AbstractButton)this.fButton){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(this.convertMouseEvent(mouseEvent));
            }

            private MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
                int n = WIMultilineControlButton.this.fButton.getWidth() / 2;
                int n2 = WIMultilineControlButton.this.fButton.getHeight() / 2;
                return new MouseEvent(WIMultilineControlButton.this.fButton, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    WIMultilineControlButton.this.toggle();
                }
            }
        };
    }

    private void updateListeners() {
        if (this.isEnabled()) {
            this.fLabel.addMouseListener(this.fMouseListener);
            this.fLabel.addKeyListener(this.fKeyListener);
        } else {
            this.fLabel.removeMouseListener(this.fMouseListener);
            this.fLabel.removeKeyListener(this.fKeyListener);
        }
    }

    private void toggle() {
        ((AbstractButton)this.fButton).setSelected(!((AbstractButton)this.fButton).isSelected());
        ((JComponent)this.fButton).requestFocus();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            ((AbstractButton)this.fButton).setEnabled(bl);
            this.fLabel.setEnabled(bl);
            this.updateListeners();
        }
    }

    protected void layOutLabel() {
        this.updateListeners();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fLabel, gridBagConstraints);
    }

    protected JTextComponent createLabel(InstWizardIntf instWizardIntf, String string) {
        final PlatformImpl platformImpl = new PlatformImpl();
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string){

            public void paintBorder(Graphics graphics) {
                if (WIMultilineControlButton.this.fButton.hasFocus()) {
                    if (platformImpl.isWindows()) {
                        int n = this.getWidth();
                        int n2 = this.getHeight();
                        BasicGraphicsUtils.drawDashedRect(graphics, 0, 3, n - 1, n2 - 4);
                    } else {
                        Color color = UIManager.getColor(WIMultilineControlButton.this.controlName + ".focus");
                        graphics.setColor(color);
                        int n = this.getWidth();
                        int n3 = this.getHeight();
                        graphics.drawRect(0, 1, n - 1, n3 - 2);
                    }
                }
            }
        };
        wIEditorPane.setOpaque(false);
        Border border = platformImpl.isMac() ? BorderFactory.createEmptyBorder(3, 2, 1, 1) : BorderFactory.createEmptyBorder(3, 0, 1, 1);
        wIEditorPane.setBorder(border);
        return wIEditorPane;
    }

    public T getButton() {
        return this.fButton;
    }
}

