/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.licensefiles.LicenseFileExt;
import com.mathworks.instwiz.InstWizardIntf;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class WILicenseFileChooser
extends JFileChooser {
    private final InstUtilResourceBundle fRes;

    public WILicenseFileChooser(InstWizardIntf instWizardIntf, String string) {
        File file = new File(string);
        file = new FolderUtilsImpl().getSearchPathForFileBrowser(file, null);
        this.setCurrentDirectory(file);
        this.fRes = instWizardIntf.getResources();
        this.setDialogTitle(this.fRes.getString("licensefile.browse.title"));
        this.setFileSelectionMode(0);
        String string2 = this.fRes.getString("button.select");
        this.setApproveButtonText(string2);
        String string3 = this.fRes.getString("button.select.mnemonic");
        int n = string3.hashCode();
        this.setApproveButtonMnemonic(n);
        this.addChoosableFileFilter(new LicenseFileFilter());
    }

    private class LicenseFileFilter
    extends FileFilter {
        private LicenseFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isFile()) {
                for (LicenseFileExt licenseFileExt : LicenseFileExt.values()) {
                    if (!file.getName().toLowerCase().endsWith(licenseFileExt.getExt())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer();
            LicenseFileExt[] licenseFileExtArray = LicenseFileExt.values();
            for (int i = 0; i < licenseFileExtArray.length; ++i) {
                stringBuffer.append("*");
                stringBuffer.append(licenseFileExtArray[i]);
                if (i >= licenseFileExtArray.length - 1) continue;
                stringBuffer.append("; ");
            }
            return MessageFormat.format(WILicenseFileChooser.this.fRes.getString("licensefile.browse.filterdesc"), stringBuffer.toString());
        }
    }
}

