/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.DefaultedModelImpl;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;

final class ProductSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final ProductModel<AvailableProduct> productModel;
    private final ProductTableFormat<AvailableProduct> productTableFormat;
    private final FileSystem fileSystem;
    private final Model<Boolean> lnuOnly;
    private final UsageDataCollector usageDataCollector;
    private final Installer install;
    private final ValidatedFik validatedFik;
    private final Model<String> licenseFilePathModel;
    private final Model<String> licenseFileContentsModel = new ModelImpl();
    private InstallWizardContext installWizardContext;
    private final DefaultedModel<String> folderModel;
    private final FileSystem downloadFileSystem;
    private final DefaultedModel<String> downloadFolderStringModel;
    private final File installFolder;

    ProductSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Installer installer, ValidatedFik validatedFik, InstallWizardContext installWizardContext, DefaultedModel<String> defaultedModel, FileSystem fileSystem, Model<Boolean> model, UsageDataCollector usageDataCollector) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installWizardContext = installWizardContext;
        this.folderModel = defaultedModel;
        this.fileSystem = fileSystem;
        this.lnuOnly = model;
        this.usageDataCollector = usageDataCollector;
        this.productModel = installModelFactory.createProductModel((SoftwareManager)installer);
        this.productTableFormat = installModelFactory.createProductTableFormat(this.productModel);
        this.install = installer;
        this.validatedFik = validatedFik;
        this.licenseFilePathModel = installModelFactory.createLicenseFileModel();
        DefaultedModel<File> defaultedModel2 = installModelFactory.createDownloadFolderModel();
        this.downloadFolderStringModel = new DefaultedModelImpl((Object)((File)defaultedModel2.get()).getAbsolutePath());
        this.downloadFileSystem = installModelFactory.createFileSystem((SoftwareManager)this.install, this.downloadFolderStringModel);
        this.installFolder = new File((String)this.folderModel.get());
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildProductSelectionStep(this.productModel, this.productTableFormat));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableDownloadSpaceStep(this.downloadFileSystem, (String)this.downloadFolderStringModel.get()));
        this.addStep(installCommandStepFactory.createCheckOverwritesStep(this.folderModel, this.install));
        this.addStep(installCommandStepFactory.createCheckControllingProductsStep(this.install, this.folderModel));
        this.addStep(installCommandStepFactory.createCheckProductDependenciesStep((SoftwareManager)this.install, this.folderModel));
        if (this.validatedFik.requiresLicenseFile()) {
            this.addStep(panelStepBuilder.buildLicenseFilePanelStep(this.licenseFilePathModel));
            this.addStep(installCommandStepFactory.createValidateLicenseFileStep(this.licenseFilePathModel, this.licenseFileContentsModel));
        }
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder(this.installWizardContext.buildConfirmationText(this.installFolder, this.install));
        stringBuilder.append((String)this.licenseFileContentsModel.get());
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        InstallOption[] installOptionArray;
        for (InstallOption installOption : installOptionArray = this.install.getInstallOptionsForCurrentProductSelection(new Product[0])) {
            if (!InstallOptionType.CLIENT_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_LICENSE_FILE.equals((Object)installOption.getType()) && !InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE.equals((Object)installOption.getType())) continue;
            installOption.setContext((String)this.licenseFileContentsModel.get());
        }
        this.collectUdcData();
        return installWorkflowFactory.createInstallOptionsWorkflow(this.install, this.installFolder, this.installWizardContext, properties, this.validatedFik, installOptionArray, this.lnuOnly);
    }

    private void collectUdcData() {
        this.usageDataCollector.removeData(UsageDataCollectorKey.PRODUCT_DATA_CLEAR_PRODUCT_DATA);
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_SIZE, (Object)this.install.getDownloadSize(new File((String)this.downloadFolderStringModel.get())));
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_INSTALLATION_SIZE, (Object)this.install.getBytesRequired(this.installFolder));
        List<AvailableProduct> list = Arrays.asList(this.install.getSelectedProductsAlreadyInstalled(this.installFolder));
        Collection collection = this.productModel.getAvailable();
        for (AvailableProduct availableProduct : collection) {
            EnumMap<UsageDataCollectorKey, Object> enumMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_NAME, (Object)availableProduct.getName());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_VERSION, (Object)availableProduct.getVersion());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BASE_CODE, (Object)availableProduct.getProductBaseCode());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BIT_CODE, (Object)availableProduct.getProductNumber());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_SELECTED, (Object)availableProduct.isSelected());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_DOWNLOADABLE, (Object)(availableProduct.getDownloadSize() != 0L ? 1 : 0));
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_INSTALLED, (Object)availableProduct.canInstall());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_REINSTALLED, (Object)list.contains(availableProduct));
            this.usageDataCollector.addData(UsageDataCollectorKey.PRODUCT_DATA_ADD_PRODUCT_DATA, enumMap);
        }
    }
}

