/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class PreLoggedInOnlineWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private static final MWAEntitlement[] EMPTY_ENTITLEMENT_ARRAY = new MWAEntitlement[0];
    private final Model<Boolean> agreeToLicense;
    private final Model<MWAEntitlement[]> entitlements;
    private final ModelImpl<String> tokenModel;
    private String email;

    PreLoggedInOnlineWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, String string, String string2) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.email = string2;
        this.tokenModel = new ModelImpl((Object)string);
        this.agreeToLicense = installModelFactory.createAgreeToLicenseSwitch();
        this.entitlements = new ModelImpl((Object)EMPTY_ENTITLEMENT_ARRAY);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createConnectToServicesStep());
        this.addStep(installCommandStepFactory.createLicenseAgreementStep(panelStepBuilder, this.agreeToLicense));
        this.addStep(installCommandStepFactory.createGetEntitlementsButAlwaysProceedStep((Model<String>)this.tokenModel, this.entitlements));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setToken((String)this.tokenModel.get());
        installWizardProperties.setEmail(this.email);
        return Boolean.toString((Boolean)this.agreeToLicense.get());
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (this.foundEntitlements()) {
            return installWorkflowFactory.createEntitlementSelectionWorkflow((MWAEntitlement[])this.entitlements.get(), (String)this.tokenModel.get(), properties);
        }
        if (this.tokenModel.get() == null) {
            return installWorkflowFactory.createLoginPanelWorkflow(properties);
        }
        return installWorkflowFactory.createProvideActivationKeyWorkflow((String)this.tokenModel.get(), properties);
    }

    private boolean foundEntitlements() {
        return ((MWAEntitlement[])this.entitlements.get()).length > 0;
    }
}

