/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

public final class EntitlementSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<MWAEntitlement[]> entitlements;
    private final Model<MWAEntitlement> selectedEntitlement;
    private final AccessibleTableFormat<MWAEntitlement> entitlementTableFormat;
    private final Model<String> activationKey;
    private final Model<Boolean> entitlementSwitch;
    private final String loginToken;

    EntitlementSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, MWAEntitlement[] mWAEntitlementArray, String string, Properties properties) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.entitlements = new ModelImpl((Object)mWAEntitlementArray);
        this.selectedEntitlement = new ModelImpl();
        this.entitlementTableFormat = installModelFactory.createEntitlementTableFormat();
        this.activationKey = installModelFactory.createActivationKeyModel();
        this.entitlementSwitch = new ModelImpl();
        this.loginToken = string;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createCheckInstallerRequirementsStep());
        this.addStep(panelStepBuilder.buildEntitlementSelectionPanelStep(this.entitlements, this.selectedEntitlement, this.entitlementTableFormat, this.entitlementSwitch, this.activationKey));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder(Boolean.toString((Boolean)this.entitlementSwitch.get()));
        if (((Boolean)this.entitlementSwitch.get()).booleanValue()) {
            stringBuilder.append(((MWAEntitlement)this.selectedEntitlement.get()).getId());
        } else {
            stringBuilder.append((String)this.activationKey.get());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (((Boolean)this.entitlementSwitch.get()).booleanValue()) {
            return installWorkflowFactory.createHasEntitlementWorkflow((MWAEntitlement)this.selectedEntitlement.get(), this.loginToken, properties);
        }
        return installWorkflowFactory.createHasActivationKeyWorkflow((String)this.activationKey.get(), this.loginToken, properties);
    }
}

