/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.OptionSelectedState;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class LoginPanelWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<String> username;
    private final Model<String> password;
    private final Model<OptionSelectedState> optionState;

    LoginPanelWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.username = installModelFactory.createUserNameModel();
        this.password = installModelFactory.createPasswordModel();
        this.optionState = new ModelImpl((Object)OptionSelectedState.NONE);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildLoginPanelStep(this.username, this.password, this.optionState));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder(this.optionState.toString());
        if (((OptionSelectedState)this.optionState.get()).equals((Object)OptionSelectedState.LOGIN)) {
            stringBuilder.append((String)this.username.get()).append((String)this.password.get());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (((OptionSelectedState)this.optionState.get()).equals((Object)OptionSelectedState.LOGIN)) {
            return installWorkflowFactory.createLoginWorkflow((String)this.username.get(), (String)this.password.get(), properties);
        }
        return installWorkflowFactory.createCreateAccountWorkflow(properties);
    }
}

