/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class InstallationWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final String confText;
    private final BackgroundTask installTask;
    private final Installer install;
    private final InstallWizardContext installWizardContext;
    private final ValidatedFik fik;
    private final InstallOption[] installOptions;
    private File installationFolder;
    private File downloadFolder;

    InstallationWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.install = installer;
        this.installWizardContext = installWizardContext;
        this.fik = validatedFik;
        this.installOptions = (InstallOption[])installOptionArray.clone();
        this.installationFolder = file;
        this.downloadFolder = new File(file, "archives");
        this.confText = this.isMCR() ? installWizardContext.buildMCRConfirmationText(file, installer) : installWizardContext.buildConfirmationText(file, installer);
        this.installTask = installModelFactory.createInstallTask(installer, file, this.downloadFolder);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.setInstallOptionsForPolyspaceStep(this.installOptions));
        this.addStep(installCommandStepFactory.createApplyInstallationOptionSelection(this.install, this.installOptions));
        this.addStep(panelStepBuilder.buildConfirmationStep(this.confText));
        this.addStep(installCommandStepFactory.createLoadFileListDataStep(this.installationFolder));
        this.addStep(installCommandStepFactory.createRunTaskStep(panelStepBuilder.buildStatusStep(this.installTask, false), this.installTask));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return "";
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createPostInstallationWorkflow(properties, this.installationFolder, (Model<File>)new ModelImpl((Object)this.downloadFolder), this.installWizardContext, this.fik, this.install, this.installOptions, (Model<Boolean>)new ModelImpl((Object)false));
    }

    private boolean isMCR() {
        return this.installWizardContext.getInstallConfiguration().getUsageId(this.install.getAvailableProducts()[0].getArchitecture(), (Product[])this.install.getAvailableProducts()).equals("mcr");
    }
}

