/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.installwizard.InstallWizardPropertyKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class InitialWorkflow
extends AbstractBranchingInstallWorkflow<Object> {
    private final File libDir;
    private final File[] archiveDirs;
    private final Model<ConnectionMode> connectionModeModel;

    InitialWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, File file, String string, Properties properties, Properties properties2) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties2);
        this.libDir = file;
        String string2 = properties.getProperty(InstallWizardPropertyKey.ARCHIVES.get());
        if (string2 == null) {
            string2 = new File(string, "archives").getAbsolutePath();
        }
        File file2 = new File(string2);
        this.archiveDirs = new File[]{file2, new File(string)};
        this.connectionModeModel = installModelFactory.createConnectionModeModel();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createLoadNativeLibrariesStep(this.libDir.getAbsolutePath()));
        this.addStep(installCommandStepFactory.createStartReadingArchivesStep(this.archiveDirs));
        this.addStep(panelStepBuilder.buildWelcomeStep(this.connectionModeModel, installCommandStepFactory.createProxyConnectToServicesStep()));
        this.addStep(installCommandStepFactory.createCheckInstallerRequirementsStep());
    }

    @Override
    protected Object evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return this.connectionModeModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (ConnectionMode.ONLINE.equals(this.connectionModeModel.get())) {
            return installWorkflowFactory.createOnlineWorkflow(properties);
        }
        return installWorkflowFactory.createOfflineWorkflow(properties);
    }
}

