/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow;

import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.input.DownloadLocationUtility;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

final class CustomWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer install;
    private final DefaultedModel<String> folderModel;
    private final DefaultedModel<File> downloadFolderModel;
    private final DefaultedModel<String> displayedFolderModel;
    private final FileSystem fileSystem;
    private final Model<String> licenseFileContentsModel = new ModelImpl();
    private ValidatedFik validatedFik;
    private InstallWizardContext installWizardContext;

    CustomWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.install = installer;
        this.validatedFik = validatedFik;
        this.installWizardContext = installWizardContext;
        this.folderModel = installModelFactory.createInstallFolderModel((Product[])this.install.getAvailableProducts());
        this.downloadFolderModel = new DefaultedModel<File>(){

            public File get() {
                return DownloadLocationUtility.getPathForReadingArchives((File)FileUtils.getFile((String[])new String[]{(String)CustomWorkflow.this.folderModel.get(), "archives"}));
            }

            public void set(File file) {
            }

            public File getDefault() {
                return null;
            }
        };
        this.displayedFolderModel = installModelFactory.createDisplayedFolderModel(this.folderModel, (Product[])this.install.getAvailableProducts());
        this.fileSystem = installModelFactory.createFileSystem((SoftwareManager)this.install, this.folderModel);
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createCheckIfNoProductsStep(new ModelImpl((Object)this.install)));
        this.addStep(panelStepBuilder.buildFolderSelectionStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckPathForExistenceStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.folderModel));
        this.addStep(installCommandStepFactory.createCheckIfOverwriteImpossibleStep(this.folderModel, this.install));
        this.addStep(installCommandStepFactory.createAddDWSArchivesInDestinationStep(this.downloadFolderModel, this.install, this.validatedFik));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.folderModel.get());
        return this.getText();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createProductSelectionWorkflow(properties, this.install, this.validatedFik, this.installWizardContext, this.folderModel, this.fileSystem, (Model<Boolean>)new ModelImpl((Object)false));
    }

    private String getText() {
        String string = System.getProperty("line.separator");
        return WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]) + string + (String)this.folderModel.get() + string + string + WizardResourceKeys.CONFIRM_PRODUCTS.getString(new Object[0]) + string + (String)this.licenseFileContentsModel.get();
    }
}

