/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.installwizard.model.InstallerStatusObserverImpl;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.model.TaskStatusObserver;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.WizardUI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractTask
implements BackgroundTask,
InstallFlowControlHandler {
    protected long totalUnits = -1L;
    protected long start;
    private final Set<TaskStatusObserver> statusObservers = new LinkedHashSet<TaskStatusObserver>();
    private final WizardUI wizardUI;
    private final ExceptionHandler exHandler;
    private TaskState state = TaskState.NOT_STARTED;
    private long idleTime = 0L;
    private Lock stateLock = new ReentrantLock();
    private Condition condition = this.stateLock.newCondition();
    private AppLogger appLogger;
    private long idleStartTime;
    private boolean retryResponse;
    private Throwable throwableException;
    protected final List<InstallStatusObserver> observers;

    AbstractTask(WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        this.wizardUI = wizardUI;
        this.exHandler = exceptionHandler;
        this.appLogger = appLogger;
        this.observers = new ArrayList<InstallStatusObserver>(Arrays.asList(installStatusObserverArray));
    }

    public abstract ResourceKeys getErrorTitleResourceKey();

    protected abstract void execute(InstallFlowControlHandler var1, InstallStatusObserver[] var2) throws IOException, InterruptedException;

    protected abstract long calculateTotalUnits();

    public TaskStatusObserver[] getTaskStatusObservers() {
        return this.statusObservers.toArray(new TaskStatusObserver[this.statusObservers.size()]);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public Boolean call() {
        this.totalUnits = this.calculateTotalUnits();
        this.observers.add((InstallStatusObserver)new InstallerStatusObserverImpl(this));
        this.start = System.currentTimeMillis();
        try {
            this.setState(TaskState.RUNNING);
            this.execute(this, this.observers.toArray(new InstallStatusObserver[this.observers.size()]));
            this.setState(TaskState.DONE);
        }
        catch (IOException iOException) {
            this.exception(iOException);
            this.setState(TaskState.CANCELLED);
        }
        catch (InterruptedException interruptedException) {
            this.setState(TaskState.CANCELLED);
        }
        return this.getState() == TaskState.DONE;
    }

    protected long getTotalUnits() {
        return this.totalUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState getState() {
        this.stateLock.lock();
        try {
            TaskState taskState = this.state;
            return taskState;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void addStatusObserver(TaskStatusObserver taskStatusObserver) {
        this.statusObservers.add(taskStatusObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        this.stateLock.lock();
        try {
            if (this.state == TaskState.RUNNING) {
                this.state = TaskState.PAUSED;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(TaskState taskState) {
        this.stateLock.lock();
        try {
            this.state = taskState;
            this.condition.signalAll();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public synchronized void resume() {
        this.setState(TaskState.RUNNING);
    }

    public synchronized void cancel() {
        this.setState(TaskState.CANCELLED);
    }

    public boolean shouldRetry(String string, String string2, Throwable throwable) {
        this.idle();
        this.throwableException = throwable;
        this.exHandler.logException(throwable);
        this.retryResponse = this.wizardUI.getResponseToYesNoQuestion(string, string2, MessageType.ERROR);
        this.active();
        return this.retryResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTaskState() throws InterruptedException {
        this.idle();
        boolean bl = false;
        while (this.getState() == TaskState.PAUSED) {
            bl = true;
            this.stateLock.lock();
            try {
                this.condition.await();
            }
            finally {
                this.stateLock.unlock();
            }
        }
        if (this.getState() == TaskState.CANCELLED) {
            throw new InterruptedException();
        }
        this.active();
        return bl;
    }

    public void alert(String string) {
        this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), string);
    }

    public void alert(Exception exception) {
        String string = exception.getMessage();
        if (string != null && !string.equalsIgnoreCase("")) {
            this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), string);
        } else {
            this.exHandler.logException((Throwable)exception);
            this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), exception.getClass().toString());
        }
    }

    public void logMsg(String string) {
        this.appLogger.logMsg(string);
    }

    public void exitImmediately(Throwable throwable) throws InterruptedException {
        this.exHandler.handleExceptionThatRequiresExit(throwable);
        throw new InterruptedException();
    }

    public void exception(Throwable throwable) {
        this.idle();
        if (!this.retryResponse && !throwable.equals(this.throwableException)) {
            this.exHandler.handleException(throwable, this.getErrorTitleResourceKey().getString(new Object[0]), throwable.getMessage());
        }
        this.active();
    }

    public void alert(String string, String string2) {
        this.idle();
        this.wizardUI.showErrorMessage(string, string2);
        this.active();
    }

    private void idle() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void active() {
        this.idleTime += System.currentTimeMillis() - this.idleStartTime;
    }

    protected static enum TaskState {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        DONE,
        CANCELLED;

    }
}

