/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Downloader;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.SoftwareManager;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

abstract class AbstractInstallWizardContext
implements InstallWizardContext {
    private static final String SEP = System.getProperty("line.separator");
    private final InstallConfiguration installConfiguration;
    private final HyperlinkProvider hyperlinkProvider;
    private final String archString;

    AbstractInstallWizardContext(InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, String string) {
        this.installConfiguration = installConfiguration;
        this.hyperlinkProvider = hyperlinkProvider;
        this.archString = string;
    }

    private static void appendOverWriteMessage(StringBuilder stringBuilder, Installer installer, File file) {
        if (installer.getSelectedProductsAlreadyInstalled(file).length > 0) {
            stringBuilder.append(SEP).append(WizardResourceKeys.CONFIRM_OVERWRITE.getString(new Object[0])).append(SEP);
        }
    }

    private static void appendDownloadPlatforms(StringBuilder stringBuilder, PlatformModel<AvailablePlatform> platformModel) {
        stringBuilder.append(SEP).append(ResourceKeys.CONFIRM_DOWNLOAD_PLATFORMS.getString(new Object[0])).append(SEP);
        for (String string : platformModel.getDisplayNamesForSelectedPlatforms()) {
            stringBuilder.append(string).append(SEP);
        }
    }

    private static void appendDownloadSize(StringBuilder stringBuilder, SoftwareManager softwareManager, File file) {
        long l = softwareManager.getDownloadSize(file);
        if (l > 0L) {
            stringBuilder.append(ResourceKeys.CONFIRM_TOTAL_DOWNLOAD_SIZE.getString(l / 0x100000L)).append(SEP);
        }
    }

    private static String assembleNotes(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br><br>");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static void appendSelectedDownloadableProducts(StringBuilder stringBuilder, SoftwareManager softwareManager) {
        AvailableProduct[] availableProductArray;
        stringBuilder.append(SEP).append(WizardResourceKeys.CONFIRM_PRODUCTS.getString(new Object[0])).append(SEP);
        for (AvailableProduct availableProduct : availableProductArray = softwareManager.getAvailableProducts()) {
            if (!availableProduct.canInstall() || availableProduct.getDownloadSize() <= 0L) continue;
            stringBuilder.append(availableProduct.getName()).append(' ').append(availableProduct.getVersion()).append(SEP);
        }
    }

    private static void appendSelectedProducts(StringBuilder stringBuilder, SoftwareManager softwareManager, boolean bl) {
        AvailableProduct[] availableProductArray;
        stringBuilder.append(SEP).append(WizardResourceKeys.CONFIRM_PRODUCTS.getString(new Object[0])).append(SEP);
        for (AvailableProduct availableProduct : availableProductArray = softwareManager.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            String string = availableProduct.getDownloadSize() > 0L && bl ? ResourceKeys.CONFIRM_DOWNLOAD.getString(availableProduct.getName() + ' ' + availableProduct.getVersion()) : availableProduct.getName() + ' ' + availableProduct.getVersion();
            stringBuilder.append(string).append(SEP);
        }
    }

    private static StringBuilder appendFolderText(StringBuilder stringBuilder, File file, String string) {
        return stringBuilder.append(string).append(SEP).append(file.getAbsolutePath()).append(SEP);
    }

    @Override
    public String buildConfirmationText(File file, Installer installer) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLicensingInformation(stringBuilder);
        AbstractInstallWizardContext.appendFolderText(stringBuilder, file, WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]));
        AbstractInstallWizardContext.appendOverWriteMessage(stringBuilder, installer, file);
        stringBuilder.append(SEP);
        AbstractInstallWizardContext.appendDownloadSize(stringBuilder, (SoftwareManager)installer, file);
        this.appendRequiredSpace(stringBuilder, (SoftwareManager)installer, file);
        AbstractInstallWizardContext.appendSelectedProducts(stringBuilder, (SoftwareManager)installer, true);
        return stringBuilder.toString();
    }

    @Override
    public String buildMCRConfirmationText(File file, Installer installer) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLicensingInformation(stringBuilder);
        AbstractInstallWizardContext.appendFolderText(stringBuilder, file, WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]));
        AbstractInstallWizardContext.appendOverWriteMessage(stringBuilder, installer, file);
        stringBuilder.append(SEP);
        AbstractInstallWizardContext.appendDownloadSize(stringBuilder, (SoftwareManager)installer, file);
        this.appendRequiredSpace(stringBuilder, (SoftwareManager)installer, file);
        stringBuilder.append(SEP).append(WizardResourceKeys.CONFIRM_PRODUCTS.getString(new Object[0])).append(SEP);
        stringBuilder.append("MATLAB Runtime").append(' ').append(installer.getAvailableProducts()[0].getVersion());
        return stringBuilder.toString();
    }

    @Override
    public String buildInstallAgentConfirmationText(String string, String string2, String string3, Model<Boolean> model, Model<Boolean> model2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WizardResourceKeys.INSTALL_AGENT_APP_INSTALL_LABEL.getString(new Object[]{string3, string2}));
        stringBuilder.append(SEP).append(SEP).append(WizardResourceKeys.INSTALL_AGENT_CONFIRMATION_MCR_LABEL.getString(new Object[]{string3, InstutilResourceKeys.RELEASE.getString(new Object[0])}));
        stringBuilder.append(SEP).append(SEP).append(this.getMCRConfirmationText(string, model, model2));
        return stringBuilder.toString();
    }

    @Override
    public String buildDownloadConfirmationText(File file, Downloader downloader, PlatformModel<AvailablePlatform> platformModel) {
        StringBuilder stringBuilder = new StringBuilder();
        AbstractInstallWizardContext.appendFolderText(stringBuilder, file, WizardResourceKeys.CONFIRMATION_DOWNLOAD_DIRECTORY.getString(new Object[0]));
        stringBuilder.append(SEP);
        AbstractInstallWizardContext.appendDownloadSize(stringBuilder, (SoftwareManager)downloader, file);
        AbstractInstallWizardContext.appendDownloadPlatforms(stringBuilder, platformModel);
        AbstractInstallWizardContext.appendSelectedDownloadableProducts(stringBuilder, (SoftwareManager)downloader);
        return stringBuilder.toString();
    }

    @Override
    public String buildNotesText(File file, InstallOption[] installOptionArray, Installer installer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.installConfiguration.getSetupNotes(file, installOptionArray, this.hyperlinkProvider, this.archString, installer)));
        return AbstractInstallWizardContext.assembleNotes(arrayList);
    }

    @Override
    public InstallConfiguration getInstallConfiguration() {
        return this.installConfiguration;
    }

    @Override
    public String buildTrialsConfirmationText(File file, Installer installer, Set<Integer> set, ResourceRetriever resourceRetriever) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendEntitledTrialsProducts(installer, stringBuilder, set, resourceRetriever);
        stringBuilder.append(SEP);
        AbstractInstallWizardContext.appendFolderText(stringBuilder, file, WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]));
        stringBuilder.append(SEP);
        AbstractInstallWizardContext.appendDownloadSize(stringBuilder, (SoftwareManager)installer, file);
        this.appendRequiredSpace(stringBuilder, (SoftwareManager)installer, file);
        return stringBuilder.toString();
    }

    private String getMCRConfirmationText(String string, Model<Boolean> model, Model<Boolean> model2) {
        String string2 = "";
        string2 = ((Boolean)model.get()).booleanValue() ? (((Boolean)model2.get()).booleanValue() ? WizardResourceKeys.INSTALL_AGENT_MCR_INSTALLED_INCREMENTAL_CONFIRMATION_LABEL.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0]), string}) : WizardResourceKeys.INSTALL_AGENT_MCR_INSTALLED_CONFIRMATION_LABEL.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0]), string})) : WizardResourceKeys.INSTALL_AGENT_MCR_NOT_INSTALLED_CONFIRMATION_LABEL.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0]), string});
        return string2;
    }

    private void appendRequiredSpace(StringBuilder stringBuilder, SoftwareManager softwareManager, File file) {
        long l = softwareManager.getBytesRequired(file);
        if (l > 0L) {
            stringBuilder.append(ResourceKeys.CONFIRM_TOTAL_INSTALLATION_SIZE.getString(l / 0x100000L)).append(SEP);
        }
    }

    private void appendEntitledTrialsProducts(Installer installer, StringBuilder stringBuilder, Set<Integer> set, ResourceRetriever resourceRetriever) {
        AvailableProduct[] availableProductArray = installer.getAvailableProducts();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (AvailableProduct availableProduct : availableProductArray) {
            if (!availableProduct.isSelected()) continue;
            if (set.contains(availableProduct.getProductNumber())) {
                this.formatProductString(stringBuilder2, availableProduct);
                continue;
            }
            this.formatProductString(stringBuilder3, availableProduct);
        }
        stringBuilder.append(WizardResourceKeys.CONFIRM_PRODUCTS.getString(resourceRetriever, new Object[0])).append(SEP).append((CharSequence)stringBuilder2);
        if (stringBuilder3.length() > 0) {
            stringBuilder.append(SEP).append(WizardResourceKeys.CONFIRM_REQUIRED_PRODUCTS.getString(resourceRetriever, new Object[0])).append(SEP).append((CharSequence)stringBuilder3).append(SEP).append(WizardResourceKeys.CONFIRM_REQUIRED_PRODUCTS_MESSAGE.getString(resourceRetriever, new Object[0])).append(SEP);
        }
    }

    private void formatProductString(StringBuilder stringBuilder, AvailableProduct availableProduct) {
        stringBuilder.append(availableProduct.getName()).append(" ").append(availableProduct.getVersion()).append(SEP);
    }

    abstract void appendLicensingInformation(StringBuilder var1);
}

