/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.installwizard.command.AbstractWebServiceCallable;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.dws.client.GetInstallerRequest;
import com.mathworks.internal.dws.client.GetInstallerReturn;
import com.mathworks.internal.dws.client.Installer;
import com.mathworks.internal.dws.client.MWMessage;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

final class GetInstallerInDownloadOnlyCallable
extends AbstractWebServiceCallable<GetInstallerReturn, MWMessage> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private static final MWMessage[] NO_MESSAGES = new MWMessage[0];
    private final Model<String[]> installerNames;
    private final DownloadService downloadService;
    private final Model<String> securityToken;
    private final Model<InstallerDownloadURLInfo[]> urlDataModel;
    private final AppLogger logger;

    GetInstallerInDownloadOnlyCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, DownloadService downloadService, Model<String[]> model, Model<String> model2, Model<InstallerDownloadURLInfo[]> model3, AppLogger appLogger, String string2) {
        super(wizardUI, exceptionHandler, string, string2);
        this.installerNames = model;
        this.downloadService = downloadService;
        this.securityToken = model2;
        this.urlDataModel = model3;
        this.logger = appLogger;
    }

    @Override
    protected int getResult(GetInstallerReturn getInstallerReturn) {
        return 0;
    }

    protected MWMessage[] getMessages(GetInstallerReturn getInstallerReturn) {
        MWMessage[] mWMessageArray = getInstallerReturn.getMessages();
        if (mWMessageArray == null) {
            return EMPTY_MESSAGE_ARRAY;
        }
        return mWMessageArray;
    }

    @Override
    protected GetInstallerReturn doCall(String string, String string2, String string3) {
        try {
            GetInstallerRequest getInstallerRequest = new GetInstallerRequest();
            getInstallerRequest.setLocale(string);
            getInstallerRequest.setRelease(string3);
            getInstallerRequest.setClientString(string2);
            getInstallerRequest.setName((String[])this.installerNames.get());
            getInstallerRequest.setToken((String)this.securityToken.get());
            return this.downloadService.getInstaller(getInstallerRequest);
        }
        catch (Throwable throwable) {
            this.logger.logMsg(throwable.getMessage());
            GetInstallerReturn getInstallerReturn = new GetInstallerReturn();
            getInstallerReturn.setResult(-1);
            getInstallerReturn.setInstaller(new Installer[0]);
            getInstallerReturn.setMessages(NO_MESSAGES);
            return getInstallerReturn;
        }
    }

    @Override
    protected boolean shouldDisplayError(MWMessage mWMessage) {
        return false;
    }

    @Override
    protected Object[] getErrorArguments(MWMessage mWMessage) {
        return new Object[]{mWMessage.getCode(), mWMessage.getDescription()};
    }

    @Override
    protected void apply(GetInstallerReturn getInstallerReturn) {
        try {
            boolean bl;
            Installer[] installerArray = getInstallerReturn.getInstaller();
            String string = System.getenv(ResourceKeys.MW_ARCHIVE_LOCATION.getString(new Object[0]));
            String string2 = System.getenv(ResourceKeys.MW_INSTALLER_LOCATION.getString(new Object[0]));
            boolean bl2 = string != null && !string.isEmpty();
            boolean bl3 = bl = string2 != null && !string2.isEmpty();
            if (installerArray.length <= 0) {
                this.logger.logMsg("No URLs returned");
            } else if (((String[])this.installerNames.get()).length != installerArray.length) {
                this.logger.logMsg("No. of urls do not match the number of architectures");
                this.logger.logMsg("Installer names length: " + ((String[])this.installerNames.get()).length + " Response Installer length: " + installerArray.length);
            } else {
                if (bl2 && !bl) {
                    return;
                }
                ArrayList<InstallerDownloadURLInfo> arrayList = new ArrayList<InstallerDownloadURLInfo>();
                for (Installer installer : installerArray) {
                    URL uRL = new URL(installer.getUrl());
                    if (bl2 && bl) {
                        uRL = new File(string2 + File.separator + installer.getName()).toURI().toURL();
                    }
                    arrayList.add(new InstallerDownloadURLInfo(installer.getName(), uRL));
                }
                this.urlDataModel.set((Object)arrayList.toArray(new InstallerDownloadURLInfo[arrayList.size()]));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.logger.logMsg(malformedURLException.getMessage());
        }
    }
}

