/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.IO;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.io.IOException;

final class DeleteDownloadedArchivesStep
extends AbstractCommandStep {
    private final File installFolder;
    private final ProductModel<AvailableProduct> productMdl;
    private final WizardUI ui;
    private final ExceptionHandler exHandler;
    private final IO io;

    DeleteDownloadedArchivesStep(WizardUI wizardUI, ExceptionHandler exceptionHandler, IO iO, File file, ProductModel<AvailableProduct> productModel) {
        this.ui = wizardUI;
        this.exHandler = exceptionHandler;
        this.io = iO;
        this.installFolder = file;
        this.productMdl = productModel;
    }

    @Override
    boolean forwardVisitStep() {
        if (this.archivesFolderExists(this.installFolder) && this.productMdl.isAnyControllingProductSelected() && this.ui.getResponseToYesNoQuestion(ResourceKeys.UNINSTALL_ARCHIVES_TITLE.getString(new Object[0]), ResourceKeys.UNINSTALL_ARCHIVES_QUESTION.getString(this.installFolder.getAbsolutePath()), MessageType.QUESTION)) {
            try {
                this.deleteArchivesFolder(this.installFolder);
            }
            catch (IOException iOException) {
                this.exHandler.handleException((Throwable)iOException);
            }
        }
        return true;
    }

    public boolean archivesFolderExists(File file) {
        return this.getArchivesFolder(file).isDirectory();
    }

    private File getArchivesFolder(File file) {
        return new File(file, "archives");
    }

    public void deleteArchivesFolder(File file) throws IOException {
        this.io.deleteDirectory(this.getArchivesFolder(file));
    }
}

