/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class CollectUdcGpuInfoStep
extends AbstractCommandStep {
    private static final String GPU_PREFIX = "<Gpu>";
    private static final String GPU_SUFFIX = "</Gpu>";
    private static final String VENDOR_PREFIX = "<Vendor>";
    private static final String VENDOR_SUFFIX = "</Vendor>";
    private static final String MODEL_PREFIX = "<Model>";
    private static final String MODEL_SUFFIX = "</Model>";
    private static final String DRIVER_PREFIX = "<Driver>";
    private static final String DRIVER_SUFFIX = "</Driver>";
    private static final String DRIVER_DATE_PREFIX = "<DriverDate>";
    private static final String DRIVER_DATE_SUFFIX = "</DriverDate>";
    private final String arch;
    private final String matlabRoot;
    private final ExecutorService executorService;
    private final AppLogger logger;
    private final UsageDataCollector usageDataCollector;

    public CollectUdcGpuInfoStep(String string, String string2, ExecutorService executorService, AppLogger appLogger, UsageDataCollector usageDataCollector) {
        this.arch = string;
        this.matlabRoot = string2;
        this.executorService = executorService;
        this.logger = appLogger;
        this.usageDataCollector = usageDataCollector;
    }

    @Override
    boolean forwardVisitStep() {
        String string = File.separator + "bin" + File.separator + this.arch + File.separator + "device_info.exe";
        FileSystem fileSystem = FileSystems.getDefault();
        Path path = fileSystem.getPath(this.matlabRoot, string);
        File file = path.toFile();
        try {
            if (file.exists() && file.canExecute()) {
                String[] stringArray = new String[]{file.toString()};
                List list = ProcessExecutorImpl.executeTaskWithOutput((String[])stringArray, (ExecutorService)this.executorService);
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    CollectUdcGpuInfoStep.addGpuId(stringBuilder, n++);
                    CollectUdcGpuInfoStep.addVendor(stringBuilder, (String)list.get(n2++));
                    CollectUdcGpuInfoStep.addModel(stringBuilder, (String)list.get(n2++));
                    CollectUdcGpuInfoStep.addDriver(stringBuilder, (String)list.get(n2++));
                    CollectUdcGpuInfoStep.addDriverDate(stringBuilder, (String)list.get(n2++));
                    this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_GPU_INFO, (Object)stringBuilder.toString());
                }
            }
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            this.logger.logMsg(string2);
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_GPU_INFO_ERROR, (Object)string2);
        }
        return true;
    }

    static void addGpuId(StringBuilder stringBuilder, int n) {
        stringBuilder.append(GPU_PREFIX);
        stringBuilder.append(n);
        stringBuilder.append(GPU_SUFFIX);
    }

    static void addVendor(StringBuilder stringBuilder, String string) {
        stringBuilder.append(VENDOR_PREFIX);
        stringBuilder.append(string);
        stringBuilder.append(VENDOR_SUFFIX);
    }

    static void addModel(StringBuilder stringBuilder, String string) {
        stringBuilder.append(MODEL_PREFIX);
        stringBuilder.append(string);
        stringBuilder.append(MODEL_SUFFIX);
    }

    static void addDriver(StringBuilder stringBuilder, String string) {
        stringBuilder.append(DRIVER_PREFIX);
        stringBuilder.append(string);
        stringBuilder.append(DRIVER_SUFFIX);
    }

    static void addDriverDate(StringBuilder stringBuilder, String string) {
        stringBuilder.append(DRIVER_DATE_PREFIX);
        stringBuilder.append(string);
        stringBuilder.append(DRIVER_DATE_SUFFIX);
    }
}

