/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.Callable;

abstract class AbstractWebServiceCallable<R, M>
implements Callable<Boolean> {
    private static final String RELEASE_STRING = WizardResourceKeys.RELEASE.getString(new Object[0]);
    private final WizardUI wizardUI;
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String title;
    private final String message;

    AbstractWebServiceCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, String string2) {
        this(wizardUI, exceptionHandler, string, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(RELEASE_STRING, string2));
    }

    AbstractWebServiceCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, String string2, String string3) {
        this.wizardUI = wizardUI;
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.title = string2;
        this.message = string3;
    }

    @Override
    public final Boolean call() throws InterruptedException {
        try {
            R r = this.doCall(Locale.getDefault().toString(), this.clientString, RELEASE_STRING);
            if (!this.processResponse(r)) {
                return false;
            }
            this.apply(r);
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception, this.title, this.message);
            return false;
        }
        return true;
    }

    private boolean processResponse(R r) {
        boolean bl = false;
        for (M m : this.getMessages(r)) {
            if (this.shouldDisplayError(m)) {
                this.showError(this.getErrorArguments(m));
                bl = true;
            }
            if (!this.shouldDisplayMessageBySeverity(m)) continue;
            this.showMessageBySeverity(this.getErrorArguments(m));
            bl = true;
        }
        int n = this.getResult(r);
        if (!bl && n != 0) {
            this.showError(n, ResourceKeys.ERROR_UNKNOWN.getString(new Object[0]));
        }
        return n == 0;
    }

    protected boolean shouldDisplayMessageBySeverity(M m) {
        return false;
    }

    protected abstract int getResult(R var1);

    protected abstract M[] getMessages(R var1);

    protected abstract R doCall(String var1, String var2, String var3) throws IOException, InterruptedException;

    protected abstract boolean shouldDisplayError(M var1);

    protected abstract Object[] getErrorArguments(M var1);

    protected abstract void apply(R var1);

    private void showError(Object ... objectArray) {
        this.wizardUI.showErrorMessage(ResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), ResourceKeys.ERROR.getString(objectArray));
    }

    protected void showMessageBySeverity(Object ... objectArray) {
    }
}

