/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.AbstractCommandStepFactory;
import com.mathworks.installwizard.command.DependencyChecker;
import com.mathworks.installwizard.command.DependencyCheckerImpl;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactoryBat;
import com.mathworks.installwizard.command.InstallCommandStepFactoryLinux;
import com.mathworks.installwizard.command.InstallCommandStepFactoryMac;
import com.mathworks.installwizard.command.InstallCommandStepFactoryWindows;
import com.mathworks.installwizard.command.RequirementsDefault;
import com.mathworks.installwizard.command.RequirementsUnix;
import com.mathworks.installwizard.command.RequirementsWindows;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.hyperlink.InstallAndLicensingHyperlinkProvider;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.mwaws.client.v6.ActivationService;
import com.mathworks.mlwebservices.loginws.LoginService;
import com.mathworks.mlwebservices.mcr_dws.MCRDWSClientFactory;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.mcrdws.MCRDWSclient;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class InstallWizardModule
extends AbstractModule {
    public static final String CLIENT_STRING = "clientString";
    public static final String CONTROLLING_PRODUCTS = "controllingProducts";
    public static final String ARCH_STRING = "archString";

    protected void configure() {
        this.bind(DependencyChecker.class).to(DependencyCheckerImpl.class);
        MCRDWSclient mCRDWSclient = MCRDWSClientFactory.createClient();
        this.bind(MCRDWSclient.class).toInstance((Object)mCRDWSclient);
    }

    @Provides
    static InstallCommandStepFactory getInstallCommandStepFactory(DownloadService downloadService, ActivationService activationService, ExecutorServiceManager executorServiceManager, InstallerBuilder installerBuilder, ExitHandler exitHandler, @Named(value="archString") String string, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, @Named(value="clientString") String string2, @Named(value="controllingProducts") String[] stringArray, Machine machine, LoginService loginService, Platform platform, IO iO, DependencyChecker dependencyChecker, InstallerRequirements installerRequirements, Properties properties, WorkerFactory workerFactory, InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, Downloader downloader, ProxyConfiguration proxyConfiguration, ProcessExecutor processExecutor, MCRDWSclient mCRDWSclient, UsageDataCollector usageDataCollector) {
        ExecutorService executorService = executorServiceManager.getMultiThreadedExecutorService();
        AbstractCommandStepFactory abstractCommandStepFactory = platform.isWindows() ? new InstallCommandStepFactoryWindows(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, loginService, activationService, downloadService, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, mCRDWSclient, usageDataCollector) : (platform.isMac() ? new InstallCommandStepFactoryMac(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, loginService, activationService, downloadService, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, mCRDWSclient, usageDataCollector) : new InstallCommandStepFactoryLinux(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, loginService, activationService, downloadService, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, mCRDWSclient, usageDataCollector));
        if (Boolean.valueOf(properties.getProperty("bat", "false")).booleanValue()) {
            return new InstallCommandStepFactoryBat(abstractCommandStepFactory);
        }
        return abstractCommandStepFactory;
    }

    @Provides
    static InstallerRequirements getInstallerRequirements(Platform platform, Properties properties) {
        if (Boolean.valueOf(properties.getProperty("bat", "false")).booleanValue()) {
            return new RequirementsDefault();
        }
        if (platform.isWindows()) {
            return new RequirementsWindows();
        }
        if (platform.isLinux() || platform.isMac()) {
            return new RequirementsUnix();
        }
        return new RequirementsDefault();
    }

    @Provides
    static Machine getMachine(File file) throws JNIException {
        return new MachineInfo(file.getAbsolutePath());
    }

    @Provides
    static File getLibDirectory(SourcePathProvider sourcePathProvider, Properties properties, Platform platform) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        if (string == null) {
            string = sourcePathProvider.getSourcePath();
        }
        return new File(platform.getNativeLibraryPath(string));
    }

    @Provides
    @Named(value="archString")
    static String getArchString(Platform platform) {
        return platform.getArchString();
    }

    @Provides
    static HyperlinkProvider provideHyperlinkProvider(final InstallConfiguration installConfiguration) {
        return new InstallAndLicensingHyperlinkProvider(){

            protected String getClientIdentifier() {
                return installConfiguration.getHyperlinkClientIdentifier();
            }
        };
    }
}

