/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.username;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.AdapterDocumentListener;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.UserNameDocument;
import com.mathworks.activationclient.view.username.UserNamePanel;
import com.mathworks.activationclient.view.username.UserNamePanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.OptionPaneHandler;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

final class UserNamePanelImpl
extends CommercialActivationPanel
implements UserNamePanel {
    private final JButton nextButton;
    private final JTextComponent uNameTextField;
    private final JButton backButton;
    private final UserNameDocument userNameDocument;
    private final UserNamePanelController panelController;
    private JToolTip uNameToolTip;
    private final String arch = MachineInfo.getArch();
    private final String userString;
    private String defaultUserName;

    UserNamePanelImpl(InstWizardIntf instWizardIntf, final UserNamePanelController userNamePanelController, final OptionPaneHandler optionPaneHandler) {
        super(instWizardIntf, CommercialActivationComponentName.USERNAME_PANEL);
        this.panelController = userNamePanelController;
        final InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        this.userString = instUtilResourceBundle.getString("label.user." + this.arch);
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.backButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                userNamePanelController.backButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.USERNAME_BACK_BUTTON);
        this.nextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UserNamePanelImpl.this.uNameTextField.getText().trim();
                if (UserNamePanelImpl.this.isValidUserName(string)) {
                    userNamePanelController.nextButton();
                } else {
                    UserNamePanelImpl.this.showWarning(instUtilResourceBundle, optionPaneHandler);
                }
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.USERNAME_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.USERNAME_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                userNamePanelController.helpButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.USERNAME_HELP_BUTTON);
        String string = instUtilResourceBundle.getString("user.bold");
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string);
        Font font = this.getBoldFont();
        jTextComponent.setFont(font);
        String string2 = instUtilResourceBundle.getString("user.top");
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = this.userString.toLowerCase().replaceAll("windows", "Windows");
        Object[] objectArray = new Object[]{string3};
        String string4 = messageFormat.format(objectArray);
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string4);
        String string5 = this.userString + instUtilResourceBundle.getString("colon");
        JTextComponent jTextComponent2 = swingComponentFactory.createLabelNonWrapping(string5);
        jTextComponent2.setFont(font);
        this.uNameTextField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.USERNAME_USER_NAME_FIELD, this.userString);
        this.userNameDocument = new UserNameDocument(instUtilResourceBundle, optionPaneHandler);
        this.userNameDocument.addDocumentListener(new AdapterDocumentListener(this.uNameTextField){

            @Override
            protected void setAdapterField(String string) {
                userNamePanelController.updateMyUserName(string);
            }
        });
        this.uNameTextField.setDocument(this.userNameDocument);
        Font font2 = this.getFont();
        int n = font2.getStyle();
        int n2 = font2.getSize();
        Font font3 = new Font("Monospaced", n, n2);
        Dimension dimension = this.uNameTextField.getPreferredSize();
        double d = dimension.getHeight();
        Graphics graphics = instWizardIntf.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font3);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Insets insets = this.uNameTextField.getInsets();
        int n3 = fontMetrics.stringWidth("12345678901234567890") + insets.left + insets.right + 1;
        Dimension dimension2 = new Dimension(n3, (int)d);
        this.uNameTextField.setPreferredSize(dimension2);
        String string6 = instUtilResourceBundle.getString("user.name.tooltip");
        this.uNameToolTip = swingComponentFactory.createToolTipText(string6, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.USERNAME_USER_NAME_TOOLTIP);
        this.uNameTextField.setToolTipText(this.uNameToolTip.getToolTipText());
        JButton[] jButtonArray = new JButton[]{this.backButton, this.nextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent});
        wIPanelBuilder.addRow(new JComponent[]{wIEditorPane});
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent2, this.uNameTextField});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string7 = instUtilResourceBundle.getString("user.title");
        this.setDefaults(this.nextButton, this.uNameTextField, string7);
    }

    private boolean isValidUserName(String string) {
        boolean bl = true;
        if (!this.arch.contains("win") && string.contains(" ")) {
            bl = false;
        }
        return bl;
    }

    private void showWarning(InstUtilResourceBundle instUtilResourceBundle, OptionPaneHandler optionPaneHandler) {
        String string = instUtilResourceBundle.getString("other.warn.spaces.title");
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = messageFormat.format(new Object[]{this.userString});
        String string3 = instUtilResourceBundle.getString("other.warn.spaces.message.self");
        messageFormat.applyPattern(string3);
        String string4 = messageFormat.format(new Object[]{this.userString.toLowerCase(), this.defaultUserName});
        optionPaneHandler.show(string4, string2, 2, -1);
    }

    @Override
    public void preDisplay() {
        this.panelController.updateMyUserName(this.uNameTextField.getText());
        super.preDisplay();
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public void setUserNameTextField(String string) {
        try {
            this.defaultUserName = string;
            this.userNameDocument.setTextWithoutCheck(string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    JButton getBackButton() {
        return this.backButton;
    }

    JTextComponent getUNameTextField() {
        return this.uNameTextField;
    }

    JToolTip getToolTipForUserName() {
        return this.uNameToolTip;
    }
}

