/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.selection;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.AdapterDocumentListener;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanel;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.LicenseTable;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.AccountFactoryImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class EntitlementSelectionPanelImpl
extends CommercialActivationPanel
implements EntitlementSelectionPanel {
    private final EntitlementSelectionPanelController controller;
    private final JButton nextButton;
    private final JTextComponent keyField;
    private final EntitlementTable entitlementTable;
    private final JScrollPane entitlementScrollPane;
    private final JRadioButton existingRadioButton;
    private final JRadioButton newRadioButton;
    private final JButton backButton;

    EntitlementSelectionPanelImpl(InstWizardIntf instWizardIntf, EntitlementSelectionPanelController entitlementSelectionPanelController) {
        super(instWizardIntf, CommercialActivationComponentName.SELECTION_PANEL);
        this.controller = entitlementSelectionPanelController;
        InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        this.entitlementTable = new EntitlementTable(this);
        this.entitlementTable.setName(CommercialActivationComponentName.SELECTION_ENTITLEMENT_TABLE.toString());
        this.entitlementScrollPane = new JScrollPane((Component)((Object)this.entitlementTable));
        JViewport jViewport = this.entitlementScrollPane.getViewport();
        jViewport.setPreferredSize(new Dimension(0, 0));
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        String string = instUtilResourceBundle.getString("select.top");
        this.keyField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.SELECTION_ACTIVATION_KEY_FIELD, string);
        Document document = this.keyField.getDocument();
        document.addDocumentListener(new AdapterDocumentListener(this.keyField){

            @Override
            protected void setAdapterField(String string) {
                EntitlementSelectionPanelImpl.this.controller.setActivationKey(string);
            }
        });
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.backButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitlementSelectionPanelImpl.this.controller.backButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_BACK_BUTTON);
        this.nextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new NextAction(), (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntitlementSelectionPanelImpl.this.controller.helpButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_HELP_BUTTON);
        String string2 = instUtilResourceBundle.getString("licsel.bold");
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string2);
        Font font = this.getBoldFont();
        jTextComponent.setFont(font);
        String string3 = instUtilResourceBundle.getString("licsel.rb1");
        this.existingRadioButton = swingComponentFactory.createRadioButton(string3, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_TABLE_RB);
        this.existingRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                EntitlementSelectionPanelImpl.this.controller.setSelectingEntitlement(n == 1);
                if (n == 2) {
                    String string = EntitlementSelectionPanelImpl.this.keyField.getText();
                    EntitlementSelectionPanelImpl.this.controller.setActivationKey(string);
                }
            }
        });
        this.newRadioButton = swingComponentFactory.createRadioButton(string, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.SELECTION_AK_FIELD_RB);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.existingRadioButton);
        buttonGroup.add(this.newRadioButton);
        String string4 = instUtilResourceBundle.getString("key.bottom");
        MessageFormat messageFormat = new MessageFormat(string4);
        String string5 = this.controller.getLocalizedHelpPath(instUtilResourceBundle.getString("help.select"));
        Object[] objectArray = new Object[]{string5};
        String string6 = messageFormat.format(objectArray);
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string6);
        JButton[] jButtonArray = new JButton[]{this.backButton, this.nextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent});
        wIPanelBuilder.addRow(new JComponent[]{this.existingRadioButton});
        wIPanelBuilder.addVerticalFillSubRow(new JComponent[]{this.entitlementScrollPane});
        wIPanelBuilder.addRow(new JComponent[]{this.newRadioButton});
        wIPanelBuilder.addSubRow(new JComponent[]{this.keyField});
        wIPanelBuilder.addSubRow(new JComponent[]{wIEditorPane});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string7 = instUtilResourceBundle.getString("licsel.title");
        this.setDefaults(this.nextButton, (Component)((Object)this.entitlementTable), string7);
        this.existingRadioButton.setOpaque(false);
        this.newRadioButton.setOpaque(false);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public void setSelectingEntitlement(boolean bl) {
        this.entitlementTable.setEnabled(bl);
        this.keyField.setEnabled(!bl);
        this.existingRadioButton.setSelected(bl);
        this.newRadioButton.setSelected(!bl);
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void setAccount(Account account) {
        this.controller.selectEntitlement(null);
        this.entitlementTable.setAccount(account);
    }

    @Override
    public void preDisplay() {
        if (this.existingRadioButton.isSelected()) {
            this.controller.setSelectingEntitlement(true);
            int n = this.entitlementTable.getSelectedRow();
            if (n >= 0) {
                String string = this.entitlementTable.getEntitlementIdAtRow(n);
                this.controller.selectEntitlement(string);
            }
        } else {
            this.controller.setSelectingEntitlement(false);
            this.controller.setActivationKey(this.keyField.getText());
        }
        super.preDisplay();
    }

    public void postDisplay() {
        if (this.entitlementTable.getRowCount() == 1) {
            this.entitlementTable.setRowSelectionInterval(0, 0);
        }
    }

    JButton getBackButton() {
        return this.backButton;
    }

    JScrollPane getEntitlementScrollPane() {
        return this.entitlementScrollPane;
    }

    LicenseTable getEntitlementTable() {
        return this.entitlementTable;
    }

    JRadioButton getExistingRadioButton() {
        return this.existingRadioButton;
    }

    JTextComponent getKeyField() {
        return this.keyField;
    }

    JRadioButton getNewRadioButton() {
        return this.newRadioButton;
    }

    private class EntitlementTable
    extends LicenseTable {
        private EntitlementTable(WIPanel wIPanel) {
            super(wIPanel, new AccountFactoryImpl().createAccount());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.isShowing() && !listSelectionEvent.getValueIsAdjusting()) {
                int n = this.getSelectedRow();
                String string = null;
                if (n > -1) {
                    string = this.getEntitlementIdAtRow(n);
                }
                EntitlementSelectionPanelImpl.this.controller.selectEntitlement(string);
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntitlementSelectionPanelImpl.this.nextButton.isEnabled()) {
                EntitlementSelectionPanelImpl.this.controller.nextButton();
            }
        }
    }
}

