/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view;

import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.ApplicationView;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.PanelInterface;
import com.mathworks.activationclient.view.activationmode.ActivationModeOptionsPanel;
import com.mathworks.activationclient.view.activationmode.ActivationModeOptionsPanelController;
import com.mathworks.activationclient.view.activationmode.ActivationModeOptionsPanelFactory;
import com.mathworks.activationclient.view.confirm.ConfirmationPanel;
import com.mathworks.activationclient.view.confirm.ConfirmationPanelController;
import com.mathworks.activationclient.view.confirm.ConfirmationPanelFactory;
import com.mathworks.activationclient.view.create.CreateAccountPanel;
import com.mathworks.activationclient.view.create.CreateAccountPanelController;
import com.mathworks.activationclient.view.create.CreateAccountPanelFactory;
import com.mathworks.activationclient.view.emailverification.EmailVerificationPanel;
import com.mathworks.activationclient.view.emailverification.EmailVerificationPanelController;
import com.mathworks.activationclient.view.emailverification.EmailVerificationPanelFactory;
import com.mathworks.activationclient.view.finish.FinalPanel;
import com.mathworks.activationclient.view.finish.FinalPanelController;
import com.mathworks.activationclient.view.finish.FinalPanelFactory;
import com.mathworks.activationclient.view.guiltscreen.GuiltPanel;
import com.mathworks.activationclient.view.guiltscreen.GuiltPanelController;
import com.mathworks.activationclient.view.guiltscreen.GuiltPanelFactory;
import com.mathworks.activationclient.view.key.ActivationKeyPanel;
import com.mathworks.activationclient.view.key.ActivationKeyPanelController;
import com.mathworks.activationclient.view.key.ActivationKeyPanelFactory;
import com.mathworks.activationclient.view.login.LoginPanel;
import com.mathworks.activationclient.view.login.LoginPanelController;
import com.mathworks.activationclient.view.login.LoginPanelFactory;
import com.mathworks.activationclient.view.options.ActivationOptionsPanel;
import com.mathworks.activationclient.view.options.ActivationOptionsPanelController;
import com.mathworks.activationclient.view.options.ActivationOptionsPanelFactory;
import com.mathworks.activationclient.view.other.ActivateOtherPanel;
import com.mathworks.activationclient.view.other.ActivateOtherPanelController;
import com.mathworks.activationclient.view.other.ActivateOtherPanelFactory;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanel;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanelController;
import com.mathworks.activationclient.view.selection.EntitlementSelectionPanelFactory;
import com.mathworks.activationclient.view.steps.NextStepsPanel;
import com.mathworks.activationclient.view.steps.NextStepsPanelController;
import com.mathworks.activationclient.view.steps.NextStepsPanelFactory;
import com.mathworks.activationclient.view.type.ActivationTypePanel;
import com.mathworks.activationclient.view.type.ActivationTypePanelController;
import com.mathworks.activationclient.view.type.ActivationTypePanelFactory;
import com.mathworks.activationclient.view.username.UserNamePanel;
import com.mathworks.activationclient.view.username.UserNamePanelController;
import com.mathworks.activationclient.view.username.UserNamePanelFactory;
import com.mathworks.activationclient.view.welcome.WelcomePanel;
import com.mathworks.activationclient.view.welcome.WelcomePanelController;
import com.mathworks.activationclient.view.welcome.WelcomePanelFactory;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.services.ProxyTester;
import com.mathworks.instwiz.DefaultCancelAction;
import com.mathworks.instwiz.InstWizard;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WICardPanel;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.webproxy.ProxyConfiguration;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public final class ApplicationViewImpl
extends InstWizard
implements ApplicationView {
    private static final String ACTIVATION_CLIENT_IDENTIFIER = "ac";
    private ApplicationController controller;
    private final ProxyConfiguration proxyConfiguration;
    private final boolean fWaitForFinish;
    private ActivateOtherPanel activateOtherPanel;
    private ActivationOptionsPanel activationOptionsPanel;
    private ActivationTypePanel activationTypePanel;
    private ConfirmationPanel confirmationPanel;
    private CreateAccountPanel createAccountPanel;
    private EmailVerificationPanel emailVerificationPanel;
    private EntitlementSelectionPanel entitlementSelectionPanel;
    private FinalPanel finalPanel;
    private LoginPanel loginPanel;
    private ActivationKeyPanel activationKeyPanel;
    private UserNamePanel userNamePanel;
    private WelcomePanel welcomePanel;
    private NextStepsPanel nextStepsPanel;
    private ActivationModeOptionsPanel activationModeOptionsPanel;
    private GuiltPanel guiltPanel;

    public ApplicationViewImpl(InstUtilResourceBundle instUtilResourceBundle, ProxyConfiguration proxyConfiguration, WILogger wILogger, boolean bl, boolean bl2) {
        super(instUtilResourceBundle, bl, bl2);
        this.proxyConfiguration = proxyConfiguration;
        this.fWaitForFinish = bl2;
        this.setUpIcon();
        ApplicationViewImpl applicationViewImpl = this;
        this.addWindowListener((WindowListener)new DefaultCancelAction((InstWizardIntf)applicationViewImpl));
        this.setLogger(wILogger);
        String string = instUtilResourceBundle.getString("log.start");
        wILogger.start(string);
        this.setName(CommercialActivationComponentName.AC_MAIN_WINDOW.toString());
    }

    @Override
    public void setApplicationController(ApplicationController applicationController) {
        this.controller = applicationController;
        this.setupGUI(this.proxyConfiguration);
    }

    public void showGUI() {
        if (this.getMachineInfo().getMachineAttributes().length == 0) {
            final InstUtilResourceBundle instUtilResourceBundle = this.getResources();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationViewImpl.this.error(instUtilResourceBundle.getString("hostid.title"), instUtilResourceBundle.getString("hostid.msg"));
                    ApplicationViewImpl.this.exit();
                }
            });
        } else {
            super.showGUI();
            if (this.fWaitForFinish) {
                this.waitUntilDone();
                this.exit();
            }
        }
    }

    private void flipTo(PanelInterface panelInterface) {
        WICardPanel wICardPanel = this.getCardPanel();
        WIPanel wIPanel = wICardPanel.getCurrentPanel();
        if (wIPanel == null || !wIPanel.equals(panelInterface)) {
            WIPanel wIPanel2 = panelInterface.getPanel();
            wIPanel2.flipBackTo();
        }
    }

    @Override
    public void showActivateOtherPanel() {
        if (null == this.activateOtherPanel) {
            ActivateOtherPanelController activateOtherPanelController = this.controller.getActivateOtherPanelAdapter();
            this.activateOtherPanel = ActivateOtherPanelFactory.createPanel(this, activateOtherPanelController);
        }
        this.flipTo(this.activateOtherPanel);
    }

    @Override
    public void showActivationOptionsPanel() {
        if (null == this.activationOptionsPanel) {
            ActivationOptionsPanelController activationOptionsPanelController = this.controller.getActivationOptionsPanelAdapter();
            this.activationOptionsPanel = ActivationOptionsPanelFactory.createPanel(this, activationOptionsPanelController);
        }
        this.flipTo(this.activationOptionsPanel);
    }

    @Override
    public void showActivationTypePanel() {
        if (null == this.activationTypePanel) {
            ActivationTypePanelController activationTypePanelController = this.controller.getActivationTypePanelAdapter();
            this.activationTypePanel = ActivationTypePanelFactory.createPanel(this, activationTypePanelController);
        }
        this.flipTo(this.activationTypePanel);
    }

    @Override
    public void showConfirmationPanel() {
        if (null == this.confirmationPanel) {
            ConfirmationPanelController confirmationPanelController = this.controller.getConfirmationPanelAdapter();
            this.confirmationPanel = ConfirmationPanelFactory.createPanel(this, confirmationPanelController);
        }
        this.flipTo(this.confirmationPanel);
    }

    @Override
    public void showCreateAccountPanel() {
        if (null == this.createAccountPanel) {
            CreateAccountPanelController createAccountPanelController = this.controller.getCreateAccountPanelAdapter();
            this.createAccountPanel = CreateAccountPanelFactory.createPanel(this, createAccountPanelController);
        }
        this.flipTo(this.createAccountPanel);
    }

    @Override
    public void showEmailVerificationPanel() {
        if (null == this.emailVerificationPanel) {
            EmailVerificationPanelController emailVerificationPanelController = this.controller.getEmailVerificationPanelAdapter();
            this.emailVerificationPanel = EmailVerificationPanelFactory.createPanel(this, emailVerificationPanelController);
        }
        this.flipTo(this.emailVerificationPanel);
    }

    @Override
    public void showActivationModeOptionsPanel() {
        if (null == this.activationModeOptionsPanel) {
            ActivationModeOptionsPanelController activationModeOptionsPanelController = this.controller.getSnuOptionsPanelAdapter();
            this.activationModeOptionsPanel = ActivationModeOptionsPanelFactory.createPanel(this, activationModeOptionsPanelController);
        }
        this.flipTo(this.activationModeOptionsPanel);
    }

    @Override
    public void showStudentGuiltScreen() {
        if (null == this.guiltPanel) {
            GuiltPanelController guiltPanelController = this.controller.getStudentGuiltScreenAdaptor();
            this.guiltPanel = GuiltPanelFactory.createPanel(this, guiltPanelController);
        }
        this.flipTo(this.guiltPanel);
    }

    @Override
    public void showEntitlementSelectionPanel() {
        if (null == this.entitlementSelectionPanel) {
            EntitlementSelectionPanelController entitlementSelectionPanelController = this.controller.getEntitlementSelectionPanelAdapter();
            this.entitlementSelectionPanel = EntitlementSelectionPanelFactory.createPanel(this, entitlementSelectionPanelController);
        }
        this.flipTo(this.entitlementSelectionPanel);
    }

    @Override
    public void showFinalPanel() {
        if (null == this.finalPanel) {
            FinalPanelController finalPanelController = this.controller.getFinalPanelAdapter();
            this.finalPanel = FinalPanelFactory.createPanel(this, finalPanelController);
        }
        this.flipTo(this.finalPanel);
    }

    @Override
    public void showLoginPanel() {
        if (null == this.loginPanel) {
            LoginPanelController loginPanelController = this.controller.getLoginPanelAdapter();
            this.loginPanel = LoginPanelFactory.createPanel(this, loginPanelController);
        }
        this.flipTo(this.loginPanel);
    }

    @Override
    public void showActivationKeyPanel() {
        if (null == this.activationKeyPanel) {
            ActivationKeyPanelController activationKeyPanelController = this.controller.getActivationKeyPanelAdapter();
            this.activationKeyPanel = ActivationKeyPanelFactory.createPanel(this, activationKeyPanelController);
        }
        this.flipTo(this.activationKeyPanel);
    }

    @Override
    public void showUserNamePanel() {
        if (null == this.userNamePanel) {
            UserNamePanelController userNamePanelController = this.controller.getUserNamePanelAdapter();
            this.userNamePanel = UserNamePanelFactory.createPanel(this, userNamePanelController);
        }
        this.flipTo(this.userNamePanel);
    }

    @Override
    public void showWelcomePanel() {
        if (null == this.welcomePanel) {
            WelcomePanelController welcomePanelController = this.controller.getWelcomePanelAdapter();
            this.welcomePanel = WelcomePanelFactory.createPanel(this, welcomePanelController);
        }
        this.flipTo(this.welcomePanel);
    }

    @Override
    public void showNextStepsPanel() {
        String string = MessageFormat.format(this.getResource("steps.text.offline"), this.getMachineInfo().getLockingString(), this.getMachineInfo().getUName(), this.getResource("releasenum.text"), this.getHyperlinkProvider().getLicenseCenterLink());
        this.showNextStepsPanel(string, false);
    }

    private void showNextStepsPanel(String string, boolean bl) {
        if (null == this.nextStepsPanel) {
            NextStepsPanelController nextStepsPanelController = this.controller.getNextStepsPanelAdapter();
            this.nextStepsPanel = NextStepsPanelFactory.createPanel(this, nextStepsPanelController);
        }
        this.nextStepsPanel.setContentPaneText(string);
        this.nextStepsPanel.showIcon(bl);
        this.flipTo(this.nextStepsPanel);
    }

    public Machine getMachineInfo() {
        ActivationModel activationModel = this.controller.getModel();
        Machine machine = null;
        if (activationModel != null) {
            machine = activationModel.getMachineInfo();
        }
        return machine;
    }

    protected final void exit() {
        super.exit();
    }

    protected String getHyperlinkClientIdentifier() {
        return ACTIVATION_CLIENT_IDENTIFIER;
    }

    @Override
    public String getResource(String string) {
        return this.getResources().getString(string);
    }

    @Override
    public void setLogLevel(String string) {
        this.getLogger().setLevel(string);
    }

    @Override
    public void setLogPath(String string) {
        this.getLogger().setLogPath(string);
    }

    @Override
    public void showLicenseFileRetrievalPanel() {
        InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        String string = instUtilResourceBundle.getString("network.cannotactivate.title");
        String string2 = instUtilResourceBundle.getString("network.cannotactivate.msg");
        this.showPanel(string2, string, 2, -1);
        String string3 = this.getResources().getString("steps.text.network");
        MessageFormat messageFormat = new MessageFormat(string3);
        String string4 = this.controller.getModel().getAccount().getSelectedEntitlement().getLicenseNumber();
        String string5 = messageFormat.format(new Object[]{string4, this.getResources().getString("appname")});
        this.showNextStepsPanel(string5, true);
    }

    public ProxyTester getProxyTester() {
        return this.controller.getModel().getProxyTester();
    }
}

