/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient;

import com.mathworks.activationclient.ActivationClientComponentFactory;
import com.mathworks.activationclient.DefaultWebServiceCaller;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.command.ControllerCommandFactoryImpl;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.ApplicationControllerImpl;
import com.mathworks.activationclient.controller.ApplicationView;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.ActivationModelImpl;
import com.mathworks.activationclient.model.WebServiceCaller;
import com.mathworks.activationclient.model.states.ActivateStateFactoryImpl;
import com.mathworks.activationclient.view.ApplicationViewImpl;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.OverrideableLicenseLocationFactory;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.mlwebservices.AccountFactory;
import com.mathworks.mlwebservices.AccountFactoryImpl;
import com.mathworks.mlwebservices.ActivationService;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.webproxy.ProxyConfiguration;
import java.util.Properties;

final class DefaultActivationClientComponentFactory
implements ActivationClientComponentFactory {
    private final Properties properties;
    private final ActivationService activationService;
    private final LoginService loginService;
    private final ProxyConfiguration proxyConfiguration;

    DefaultActivationClientComponentFactory(Properties properties, ActivationService activationService, LoginService loginService, ProxyConfiguration proxyConfiguration) {
        this.properties = properties;
        this.activationService = activationService;
        this.loginService = loginService;
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    public ActivationModel createActivationModel(InstWizardIntf instWizardIntf, WebServiceCaller webServiceCaller) {
        ActivateStateFactoryImpl activateStateFactoryImpl = new ActivateStateFactoryImpl();
        AccountFactoryImpl accountFactoryImpl = new AccountFactoryImpl();
        OverrideableLicenseLocationFactory overrideableLicenseLocationFactory = new OverrideableLicenseLocationFactory(this.properties);
        return new ActivationModelImpl(instWizardIntf, webServiceCaller, activateStateFactoryImpl, (AccountFactory)accountFactoryImpl, (LicenseLocationFactory)overrideableLicenseLocationFactory, this.properties);
    }

    @Override
    public ApplicationController createApplicationController(ControllerCommandFactory controllerCommandFactory, ApplicationView applicationView, ActivationModel activationModel) {
        return new ApplicationControllerImpl(controllerCommandFactory, applicationView, activationModel);
    }

    @Override
    public ApplicationView createApplicationView(WIResourceBundle wIResourceBundle, WILogger wILogger, boolean bl, boolean bl2) {
        return new ApplicationViewImpl((InstUtilResourceBundle)wIResourceBundle, this.proxyConfiguration, wILogger, bl, bl2);
    }

    @Override
    public ControllerCommandFactory createControllerCommandFactory() {
        return new ControllerCommandFactoryImpl();
    }

    @Override
    public WebServiceCaller createWebServiceCaller(ApplicationView applicationView) {
        DefaultWebServiceCaller defaultWebServiceCaller = new DefaultWebServiceCaller(this.activationService, this.loginService);
        defaultWebServiceCaller.setView(applicationView);
        return defaultWebServiceCaller;
    }
}

