/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.workflow;

import com.mathworks.wizard.Step;
import com.mathworks.wizard.Wizard;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import com.mathworks.wizard.workflow.ConditionalStep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class AbstractWorkflow
implements Workflow {
    private MyWizard wiz;

    AbstractWorkflow() {
    }

    @Override
    public final void construct(Wizard wizard, PanelStepBuilder panelStepBuilder) {
        if (this.wiz == null) {
            this.wiz = new MyWizard();
            this.construct(panelStepBuilder);
        }
        Iterator<Step> iterator = this.wiz.stepIterator();
        while (iterator.hasNext()) {
            wizard.addStep(iterator.next());
        }
    }

    protected abstract void construct(PanelStepBuilder var1);

    protected final Wizard addStep(Step step) {
        this.wiz.addStep(step);
        return this.wiz;
    }

    protected final Wizard addConditionalSteps(Condition condition, Step ... stepArray) {
        for (Step step : stepArray) {
            this.wiz.addStep(new ConditionalStep(step, condition));
        }
        return this.wiz;
    }

    private static class MyWizard
    implements Wizard {
        private final List<Step> steps = new ArrayList<Step>();

        private MyWizard() {
        }

        @Override
        public Wizard addStep(Step step) {
            this.steps.add(step);
            return this;
        }

        Iterator<Step> stepIterator() {
            return this.steps.iterator();
        }
    }
}

