/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.ProxyContainer;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.help.Help;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import com.mathworks.wizard.ui.panels.ProxyConfigurator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class WelcomePanelUI
extends AbstractPanelUI {
    private final JPanel panel;
    private final AbstractButton onlineButton;
    private URI hlpURI;
    private Model<ConnectionMode> connectionModeModel;
    private final Step bindStep;
    private final ResourceRetriever resourceRetriever;

    WelcomePanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, URI uRI, WizardUI wizardUI, Model<ConnectionMode> model, ProxyConfigurator proxyConfigurator, Step step, ResourceRetriever resourceRetriever, Help help) {
        super(resourceBundle, swingComponentFactory, resourceRetriever.getResource(WizardResourceKeys.WELCOME_TITLE, resourceRetriever.getResource(WizardResourceKeys.PRODUCT_NAME, new Object[0])));
        JComponent jComponent;
        this.hlpURI = uRI;
        this.connectionModeModel = model;
        this.bindStep = step;
        this.resourceRetriever = resourceRetriever;
        JComponent jComponent2 = swingComponentFactory.createLabel(this.getUpperText(uRI), WizardComponentName.WELCOME_UPPER_TEXT);
        panelBuilder.addRow(new JComponent[]{jComponent2});
        this.onlineButton = this.createOnlineButton(swingComponentFactory);
        JComponent jComponent3 = swingComponentFactory.createLabel(WizardResourceKeys.WELCOME_RADIOBUTTON_ONLINE_SUBTEXT.getString(resourceRetriever, new Object[0]), WizardComponentName.WELCOME_RADIOBUTTON_ONLINE_SUBTEXT);
        AbstractButton abstractButton = this.createAdvancedButton(swingComponentFactory, wizardUI, proxyConfigurator);
        AbstractButton abstractButton2 = this.createOfflineButton(swingComponentFactory);
        JComponent jComponent4 = swingComponentFactory.createLabel(WizardResourceKeys.WELCOME_RADIOBUTTON_OFFLINE_SUBTEXT.getString(resourceRetriever, new Object[0]), WizardComponentName.WELCOME_RADIOBUTTON_OFFLINE_SUBTEXT);
        double d = Math.ceil((float)jComponent4.getFont().getSize() * 0.16f);
        JComponent jComponent5 = swingComponentFactory.createLabel(WizardResourceKeys.WELCOME_FIK_LINK.getString(resourceRetriever, help.getHelpURI("help.fik.link"), d), WizardComponentName.WELCOME_FIK_LINK);
        swingComponentFactory.createRelationship(this.onlineButton, abstractButton);
        swingComponentFactory.createButtonGroup(this.onlineButton, abstractButton2);
        if (!ConnectionMode.OFFLINE_ONLY.equals((Object)this.connectionModeModel.get())) {
            this.onlineButton.setSelected(ConnectionMode.ONLINE.equals((Object)this.connectionModeModel.get()));
            abstractButton2.setSelected(ConnectionMode.OFFLINE.equals((Object)this.connectionModeModel.get()));
            jComponent = swingComponentFactory.createPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.025;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jComponent.add((Component)abstractButton2, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 20;
            gridBagConstraints2.insets = new Insets(0, 0, 4, 0);
            jComponent.add((Component)jComponent5, gridBagConstraints2);
            panelBuilder.addLeftWeightedRow(new JComponent[]{this.onlineButton, abstractButton});
            panelBuilder.addSubRow(new JComponent[]{jComponent3});
            panelBuilder.addRow(new JComponent[]{swingComponentFactory.createLabel("", WizardComponentName.EMPTY_COMPONENT)});
            panelBuilder.addRow(new JComponent[]{swingComponentFactory.createLabel("", WizardComponentName.EMPTY_COMPONENT)});
            panelBuilder.addRow(new JComponent[]{jComponent});
            panelBuilder.addSubRow(new JComponent[]{jComponent4});
        }
        jComponent = swingComponentFactory.createLabel(this.getLowerText(), WizardComponentName.WELCOME_LOWER_TEXT);
        panelBuilder.addVerticalFillRow(new JComponent[0]);
        panelBuilder.addRow(new JComponent[]{jComponent});
        panelBuilder.addRow(new JComponent[]{swingComponentFactory.createLabel(this.getFooterText(), WizardComponentName.WELCOME_FOOTER)});
        this.panel = panelBuilder.buildPanel();
    }

    private String getFooterText() {
        return WizardResourceKeys.WELCOME_FOOTER.getString(this.resourceRetriever, new Object[0]);
    }

    private AbstractButton createOnlineButton(SwingComponentFactory swingComponentFactory) {
        String string = WizardResourceKeys.WELCOME_RADIOBUTTON_ONLINE.getString(this.resourceRetriever, new Object[0]);
        AbstractButton abstractButton = swingComponentFactory.createRadioButton(string, WizardComponentName.WELCOME_ONLINE_RADIOBUTTON);
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePanelUI.this.connectionModeModel.set(ConnectionMode.ONLINE);
            }
        });
        return abstractButton;
    }

    private AbstractButton createAdvancedButton(SwingComponentFactory swingComponentFactory, WizardUI wizardUI, ProxyConfigurator proxyConfigurator) {
        return swingComponentFactory.createButton(AllButtonProperties.ADVANCED, new AdvancedButtonAction(swingComponentFactory, wizardUI, proxyConfigurator), WizardComponentName.WELCOME_ADVANCED_BUTTON);
    }

    private AbstractButton createOfflineButton(SwingComponentFactory swingComponentFactory) {
        String string = WizardResourceKeys.WELCOME_RADIOBUTTON_OFFLINE.getString(this.resourceRetriever, new Object[0]);
        AbstractButton abstractButton = swingComponentFactory.createRadioButton(string, WizardComponentName.WELCOME_OFFLINE_RADIOBUTTON);
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePanelUI.this.connectionModeModel.set(ConnectionMode.OFFLINE);
            }
        });
        return abstractButton;
    }

    private String getLowerText() {
        String string = System.getProperty("line.separator");
        return WizardResourceKeys.WELCOME_TEXT_PROFESSIONAL.getString(this.resourceRetriever, new Object[0]) + string + string + WizardResourceKeys.TRADEMARK.getString(new Object[0]);
    }

    private String getUpperText(URI uRI) {
        return this.resourceRetriever.getResource(WizardResourceKeys.WELCOME_HEADER_PROFESSIONAL, uRI, this.resourceRetriever.getResource(WizardResourceKeys.PRODUCT_NAME, new Object[0]));
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return ConnectionMode.OFFLINE_ONLY.equals((Object)this.connectionModeModel.get()) ? jComponent : this.onlineButton;
    }

    @Override
    public String getAccessibleName() {
        String string = WizardResourceKeys.WELCOME_ACCESSIBLE.getString(new Object[0]);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{this.getUpperText(this.hlpURI), this.getLowerText()};
        return messageFormat.format(objectArray);
    }

    @Override
    public void configureBackButton(AbstractButton abstractButton) {
        abstractButton.setEnabled(false);
    }

    private class AdvancedButtonAction
    extends AbstractAction {
        private final SwingComponentFactory componentFactory;
        private final WizardUI ui;
        private final ProxyConfigurator proxyConfigurator;
        private final ProxyContainer proxyContainer;

        AdvancedButtonAction(SwingComponentFactory swingComponentFactory, WizardUI wizardUI, ProxyConfigurator proxyConfigurator) {
            this.componentFactory = swingComponentFactory;
            this.ui = wizardUI;
            this.proxyConfigurator = proxyConfigurator;
            this.proxyContainer = this.componentFactory.createProxyPanel(this.ui);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.proxyConfigurator.configure(this.proxyContainer, WelcomePanelUI.this.bindStep);
        }
    }
}

