/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.components.TableProvider;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class UninstallerProductSelectionPanelUI<T>
extends AbstractPanelUI {
    private JPanel panel;
    private ProductModel<T> prodModel;
    private TableProvider productTableProvider;

    public UninstallerProductSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, final ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, SourcePathProvider sourcePathProvider, Model<Boolean> model, InstallOptionModel ... installOptionModelArray) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.UNINSTALL_PRODUCTSELECTION_TITLE.getString(new Object[0]));
        this.prodModel = productModel;
        JComponent jComponent = model.get() != false ? swingComponentFactory.createLabel(MessageFormat.format(WizardResourceKeys.UNINSTALL_TEXT.getString(new Object[0]), sourcePathProvider.getSourcePath()), WizardComponentName.UNINSTALL_LABEL) : swingComponentFactory.createLabel(MessageFormat.format(WizardResourceKeys.UNINSTALL_TEXT_MCR.getString(new Object[0]), sourcePathProvider.getSourcePath()), WizardComponentName.UNINSTALL_LABEL);
        final LinkedHashMap<AbstractButton, InstallOptionModel> linkedHashMap = new LinkedHashMap<AbstractButton, InstallOptionModel>();
        for (InstallOptionModel installOptionModel : installOptionModelArray) {
            AbstractButton abstractButton = swingComponentFactory.createCheckBox(WizardResourceKeys.UNINSTALL_MATLAB_PREFS.getString(new Object[0]), WizardComponentName.UNINSTALL_MATLAB_PREFS_CHECKBOX);
            swingComponentFactory.createAssociation(abstractButton, installOptionModel);
            abstractButton.setEnabled(productModel.isAnyControllingProductSelected());
            linkedHashMap.put(abstractButton, installOptionModel);
        }
        this.productTableProvider = swingComponentFactory.createProductTable(productModel, productTableFormat, new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                boolean bl = productModel.isAnyControllingProductSelected();
                for (AbstractButton abstractButton : linkedHashMap.keySet()) {
                    abstractButton.setEnabled(bl);
                    if (bl) {
                        ((InstallOptionModel)linkedHashMap.get(abstractButton)).setSelected(abstractButton.isSelected());
                        continue;
                    }
                    ((InstallOptionModel)linkedHashMap.get(abstractButton)).setSelected(false);
                }
            }
        });
        panelBuilder.addRow(new JComponent[]{jComponent});
        if (model.get().booleanValue()) {
            panelBuilder.addVerticalFillRow(new JComponent[]{this.productTableProvider.getComponent()});
        }
        for (AbstractButton abstractButton : linkedHashMap.keySet()) {
            panelBuilder.addRow(new JComponent[]{abstractButton});
        }
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return jComponent;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.UNINSTALL_PRODUCTSELECTION_TITLE_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureBackButton(AbstractButton abstractButton) {
        abstractButton.setEnabled(false);
        abstractButton.setVisible(false);
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        this.factory.setButtonProperties(abstractButton, AllButtonProperties.UNINSTALL);
        abstractButton.setEnabled(this.prodModel.anySelected());
        this.productTableProvider.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                abstractButton.setEnabled(UninstallerProductSelectionPanelUI.this.prodModel.anySelected());
            }
        });
    }

    @Override
    public void configureHelpButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }
}

