/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.google.inject.Inject;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.navigation.NavigationButtonFactory;
import com.mathworks.wizard.ui.navigation.NavigationPanelBuilder;
import com.mathworks.wizard.ui.panels.PanelStep;
import com.mathworks.wizard.ui.panels.PanelStepFactory;
import com.mathworks.wizard.ui.panels.PanelUI;

final class PanelStepFactoryImpl
implements PanelStepFactory {
    private final NavigationButtonFactory navButtonFactory;
    private final NavigationPanelBuilder navPanelBuilder;
    private final WizardUI container;
    private final ExitHandler exitHandler;
    private final ResourceRetriever resources;
    private int panelStepCount = 0;
    private AppLogger logger;

    @Inject
    PanelStepFactoryImpl(NavigationButtonFactory navigationButtonFactory, NavigationPanelBuilder navigationPanelBuilder, WizardUI wizardUI, ExitHandler exitHandler, ResourceRetriever resourceRetriever, AppLogger appLogger) {
        this.navButtonFactory = navigationButtonFactory;
        this.navPanelBuilder = navigationPanelBuilder;
        this.container = wizardUI;
        this.exitHandler = exitHandler;
        this.resources = resourceRetriever;
        this.logger = appLogger;
    }

    @Override
    public Step createPanelStep(PanelUI panelUI) {
        String string = this.getName();
        return new PanelStep(panelUI, this.navButtonFactory, this.navPanelBuilder, this.container, string, this.exitHandler, this.resources, this.logger, true, new BackgroundTask[0]);
    }

    @Override
    public Step createPanelStep(PanelUI panelUI, String string) {
        return this.createPanelStep(panelUI, string, true);
    }

    @Override
    public Step createPanelStep(PanelUI panelUI, String string, boolean bl) {
        String string2 = this.getName();
        return new PanelStep(panelUI, this.navButtonFactory, this.navPanelBuilder, this.container, string2, this.exitHandler, string, this.resources, this.logger, bl, new BackgroundTask[0]);
    }

    @Override
    public Step createPanelStep(PanelUI panelUI, BackgroundTask backgroundTask) {
        return this.createPanelStep(panelUI, backgroundTask, true);
    }

    @Override
    public Step createPanelStep(PanelUI panelUI, BackgroundTask backgroundTask, boolean bl) {
        String string = this.getName();
        return new PanelStep(panelUI, this.navButtonFactory, this.navPanelBuilder, this.container, string, this.exitHandler, this.resources, this.logger, bl, backgroundTask);
    }

    @Override
    public Step createPanelStep(PanelUI panelUI, BackgroundTask backgroundTask, boolean bl, WizardResourceKeys wizardResourceKeys) {
        String string = this.getName();
        return new PanelStep(panelUI, this.navButtonFactory, this.navPanelBuilder, this.container, string, this.exitHandler, this.resources, this.logger, bl, backgroundTask, wizardResourceKeys);
    }

    private synchronized String getName() {
        return this.getClass().toString() + String.valueOf(++this.panelStepCount);
    }
}

