/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view.config;

import com.mathworks.vrd.license.License;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.LicenseList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class SerialAction
extends AbstractAction {
    private final VRDModel fModel;
    private final LicenseList fList;
    private final ActionListener fDoneAction;

    SerialAction(String string, VRDModel vRDModel, LicenseList licenseList, ActionListener actionListener) {
        super(string);
        this.setEnabled(false);
        this.fModel = vRDModel;
        this.fList = licenseList;
        this.fDoneAction = actionListener;
        this.fList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SerialAction.this.updateActionStatus();
            }
        });
        this.updateActionStatus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<License> collection = this.fList.getSelectedLicenses();
        for (License license : collection) {
            this.performActionOnLicense(this.fModel, license, this.fList);
        }
        this.updateActionStatus();
        this.fList.setFocus();
        if (this.fDoneAction != null) {
            this.fDoneAction.actionPerformed(actionEvent);
        }
    }

    abstract boolean isActionEnabledOnLicense(VRDModel var1, License var2);

    abstract void performActionOnLicense(VRDModel var1, License var2, LicenseList var3);

    private void updateActionStatus() {
        boolean bl = false;
        Collection<License> collection = this.fList.getSelectedLicenses();
        for (License license : collection) {
            if (!this.isActionEnabledOnLicense(this.fModel, license)) continue;
            bl = true;
        }
        this.setEnabled(bl);
    }
}

