/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view.config;

import com.mathworks.instwiz.resources.ComponentName;
import com.mathworks.vrd.command.DeactivateCommand;
import com.mathworks.vrd.command.DeactivateCommandFactory;
import com.mathworks.vrd.command.DeactivateStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.resources.VRDComponentName;
import com.mathworks.vrd.view.LicenseList;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.vrd.view.config.LicenseUIConfig;
import com.mathworks.vrd.view.config.SerialAction;
import java.awt.event.ActionListener;
import javax.swing.Action;

final class DeactivateUIConfig
implements LicenseUIConfig {
    private final VRDModel fModel;
    private final VRDView fView;
    private final DeactivateCommandFactory fFactory;
    private boolean fShowStatus = true;

    DeactivateUIConfig(VRDModel vRDModel, VRDView vRDView, DeactivateCommandFactory deactivateCommandFactory) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fFactory = deactivateCommandFactory;
    }

    @Override
    public String getTitle() {
        return this.fView.intlString("welcome.deactivate.title");
    }

    @Override
    public String getDescription() {
        return this.fView.intlString("welcome.deactivate.text");
    }

    @Override
    public String getListTitle() {
        return this.fView.intlString("welcome.deactivate.list");
    }

    @Override
    public String getDisplayedLicenseStatus(License license) {
        if (!this.fModel.canDeactivate(license) && license.getLicenseStatus().equals((Object)LicenseStatus.INITIAL)) {
            return this.fView.intlString("status.cannotdeactivate");
        }
        return license.getLicenseStatus().getDisplayedValue(this.fView);
    }

    @Override
    public boolean isLicenseStatusVisible() {
        return this.fShowStatus;
    }

    @Override
    public void setLicenseStatusVisible(boolean bl) {
        this.fShowStatus = bl;
    }

    @Override
    public boolean isMultiSelectSupported() {
        return false;
    }

    @Override
    public boolean isSelectByDefaultEnabled() {
        return false;
    }

    @Override
    public boolean isDefaultCloseOperationEnabled() {
        return true;
    }

    @Override
    public Action createUIAction(LicenseList licenseList, ActionListener actionListener) {
        String string = this.fView.intlString("welcome.deactivate.confirm");
        return new DeactivateSerialAction(string, this.fModel, licenseList, this.fFactory, actionListener);
    }

    @Override
    public ComponentName getActionComponentName() {
        return VRDComponentName.DEACTIVATE_UI_ACTION;
    }

    private static class DeactivateSerialAction
    extends SerialAction {
        private final DeactivateCommandFactory fCmdFactory;

        private DeactivateSerialAction(String string, VRDModel vRDModel, LicenseList licenseList, DeactivateCommandFactory deactivateCommandFactory, ActionListener actionListener) {
            super(string, vRDModel, licenseList, actionListener);
            this.fCmdFactory = deactivateCommandFactory;
        }

        @Override
        boolean isActionEnabledOnLicense(VRDModel vRDModel, License license) {
            return vRDModel.canDeactivate(license);
        }

        @Override
        void performActionOnLicense(VRDModel vRDModel, License license, LicenseList licenseList) {
            if (vRDModel.canDeactivate(license)) {
                DeactivateCommand deactivateCommand = this.fCmdFactory.createDeactivateCommand(true);
                DeactivateStatus deactivateStatus = deactivateCommand.deactivate(license);
                licenseList.updateLicense(license);
            }
        }
    }
}

