/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.view.config;

import com.mathworks.instwiz.resources.ComponentName;
import com.mathworks.vrd.command.DeactivateCommand;
import com.mathworks.vrd.command.DeactivateCommandFactory;
import com.mathworks.vrd.command.DeactivateStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.resources.VRDComponentName;
import com.mathworks.vrd.view.LicenseList;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.vrd.view.config.LicenseUIConfig;
import com.mathworks.vrd.view.config.SerialAction;
import java.awt.event.ActionListener;
import javax.swing.Action;

final class DeactivateRequiredUIConfig
implements LicenseUIConfig {
    private final VRDModel fModel;
    private final VRDView fView;
    private final DeactivateCommandFactory fFactory;
    private boolean fShowStatus = false;

    DeactivateRequiredUIConfig(VRDModel vRDModel, VRDView vRDView, DeactivateCommandFactory deactivateCommandFactory) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fFactory = deactivateCommandFactory;
    }

    @Override
    public String getTitle() {
        return this.fView.intlString("required.deactivate.title");
    }

    @Override
    public String getDescription() {
        return this.fView.intlString("required.deactivate.text");
    }

    @Override
    public String getListTitle() {
        return this.fView.intlString("required.deactivate.list");
    }

    @Override
    public String getDisplayedLicenseStatus(License license) {
        return license.getLicenseStatus().getDisplayedValue(this.fView);
    }

    @Override
    public boolean isLicenseStatusVisible() {
        return this.fShowStatus;
    }

    @Override
    public void setLicenseStatusVisible(boolean bl) {
        this.fShowStatus = bl;
    }

    @Override
    public boolean isMultiSelectSupported() {
        return false;
    }

    @Override
    public boolean isSelectByDefaultEnabled() {
        return true;
    }

    @Override
    public boolean isDefaultCloseOperationEnabled() {
        return false;
    }

    @Override
    public Action createUIAction(LicenseList licenseList, ActionListener actionListener) {
        String string = this.fView.intlString("required.deactivate.confirm");
        return new DeactivateRequiredSerialAction(string, this.fModel, licenseList, this.fFactory, actionListener);
    }

    @Override
    public ComponentName getActionComponentName() {
        return VRDComponentName.DEACTIVATE_REQUIRED_UI_ACTION;
    }

    private static class DeactivateRequiredSerialAction
    extends SerialAction {
        private final DeactivateCommandFactory fCmdFactory;

        private DeactivateRequiredSerialAction(String string, VRDModel vRDModel, LicenseList licenseList, DeactivateCommandFactory deactivateCommandFactory, ActionListener actionListener) {
            super(string, vRDModel, licenseList, actionListener);
            this.fCmdFactory = deactivateCommandFactory;
        }

        @Override
        boolean isActionEnabledOnLicense(VRDModel vRDModel, License license) {
            return license.getLicenseStatus().equals((Object)LicenseStatus.DEACTIVATE_REQUIRED);
        }

        @Override
        void performActionOnLicense(VRDModel vRDModel, License license, LicenseList licenseList) {
            if (license.getLicenseStatus().equals((Object)LicenseStatus.DEACTIVATE_REQUIRED)) {
                DeactivateCommand deactivateCommand = this.fCmdFactory.createDeactivateCommand(false);
                DeactivateStatus deactivateStatus = deactivateCommand.deactivate(license);
                licenseList.updateLicense(license);
            }
        }
    }
}

