/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.model;

import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.ActivationType;
import com.mathworks.instutil.licensefiles.LicenseFileFinder;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.instutil.licensefiles.LicenseInfoAdapter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.instutil.licensefiles.LicenseUtil;
import com.mathworks.instutil.services.AbstractServiceThread;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadFactory;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.mwaws.client.v6.MWAMachineAttribute;
import com.mathworks.mlwebservices.Service;
import com.mathworks.mlwebservices.ValidationService;
import com.mathworks.vrd.command.ChangeIt;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseFileFilter;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.VRDView;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

final class VRDModelImpl
implements VRDModel {
    private final VRDView fView;
    private final ValidationService fService;
    private final Machine fMachine;
    private final LicenseFileFinder fFinder;
    private final LicenseFileFilter fFilter;
    private final String fUserLoginName;
    private MWAMachineAttribute[] fAttributes;
    private static final String PREFIX = "NV_";
    private final ServiceThreadFactory serviceThreadFactory;
    private final FolderUtils folderUtils = new FolderUtilsImpl();
    private final IO io;

    VRDModelImpl(VRDView vRDView, ValidationService validationService, Machine machine, LicenseFileFinder licenseFileFinder, LicenseFileFilter licenseFileFilter, String string, ServiceThreadFactory serviceThreadFactory, IO iO) {
        this.fView = vRDView;
        this.fService = validationService;
        this.fMachine = machine;
        this.fFinder = licenseFileFinder;
        this.fFilter = licenseFileFilter;
        this.fUserLoginName = string;
        this.io = iO;
        this.fAttributes = this.fMachine.getMachineAttributes();
        this.serviceThreadFactory = serviceThreadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectNow() throws InterruptedException {
        if (!this.fService.isConnected()) {
            try {
                this.fView.setErrorsVisible(false);
                ServiceThread serviceThread = this.serviceThreadFactory.createBindingThread((ServiceThreadView)this.fView, new Service[]{this.fService}, null, false);
                serviceThread.startAndWait();
                if (serviceThread.isCancelled()) {
                    throw new InterruptedException();
                }
            }
            finally {
                this.fView.setErrorsVisible(true);
            }
        }
        return this.fService.isConnected();
    }

    @Override
    public int validate(License license) throws InterruptedException {
        int n = -1;
        if (this.fService.isConnected()) {
            ServiceThread serviceThread = null;
            String string = license.getLicenseNumber();
            int n2 = license.getEntitlementId();
            String string2 = LicenseUtil.getMatchingUserLoginNameForUserLockingString((String)license.getUserLockingString(), (String)this.fUserLoginName);
            if (n2 > 0) {
                serviceThread = this.serviceThreadFactory.createValidateByEntitlementIdThread((ServiceThreadView)this.fView, this.fService, n2, this.fAttributes, string2);
            } else {
                try {
                    int n3 = Integer.parseInt(string);
                    serviceThread = this.serviceThreadFactory.createValidateThread((ServiceThreadView)this.fView, this.fService, n3, this.fAttributes, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (serviceThread != null) {
                serviceThread.startAndWait();
                if (serviceThread.isCancelled()) {
                    throw new InterruptedException();
                }
                n = (Integer)serviceThread.getResult();
            }
        }
        return n;
    }

    @Override
    public String refresh(License license) throws InterruptedException {
        String string = "";
        if (this.fService.isConnected()) {
            ServiceThread serviceThread = null;
            String string2 = license.getLicenseNumber();
            int n = license.getEntitlementId();
            String string3 = LicenseUtil.getMatchingUserLoginNameForUserLockingString((String)license.getUserLockingString(), (String)this.fUserLoginName);
            if (n > 0) {
                serviceThread = this.serviceThreadFactory.createRefreshByEntitlementIdThread((ServiceThreadView)this.fView, this.fService, n, this.fAttributes, string3);
            } else {
                try {
                    int n2 = Integer.parseInt(string2);
                    serviceThread = this.serviceThreadFactory.createRefreshThread((ServiceThreadView)this.fView, this.fService, n2, this.fAttributes, string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (serviceThread != null) {
                LicenseStatus licenseStatus = license.getLicenseStatus();
                boolean bl = !licenseStatus.equals((Object)LicenseStatus.UPDATE_REQUIRED);
                serviceThread.setCancellable(bl);
                serviceThread.startAndWait();
                if (serviceThread.isCancelled()) {
                    throw new InterruptedException();
                }
                string = (String)serviceThread.getResult();
            }
        }
        return string;
    }

    @Override
    public boolean deactivate(License license) throws InterruptedException {
        boolean bl = false;
        if (this.fService.isConnected()) {
            ServiceThread serviceThread = null;
            String string = license.getLicenseNumber();
            int n = license.getEntitlementId();
            String string2 = LicenseUtil.getMatchingUserLoginNameForUserLockingString((String)license.getUserLockingString(), (String)this.fUserLoginName);
            if (n > 0) {
                serviceThread = this.serviceThreadFactory.createDeactivateByEntitlementIdThread((ServiceThreadView)this.fView, this.fService, "", n, this.fAttributes, string2);
            } else {
                try {
                    int n2 = Integer.parseInt(string);
                    serviceThread = this.serviceThreadFactory.createDeactivateThread((ServiceThreadView)this.fView, this.fService, "", n2, this.fAttributes, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (serviceThread != null) {
                LicenseStatus licenseStatus = license.getLicenseStatus();
                boolean bl2 = !licenseStatus.equals((Object)LicenseStatus.DEACTIVATE_REQUIRED);
                serviceThread.setCancellable(bl2);
                serviceThread.startAndWait();
                if (serviceThread.isCancelled()) {
                    throw new InterruptedException();
                }
                bl = serviceThread.getStatus() == ServiceThreadState.SUCCESS;
            }
        }
        return bl;
    }

    @Override
    public boolean writeStringToLicenseFile(String string, File file) {
        boolean bl;
        try {
            String string2 = string;
            String string3 = System.getProperty("line.separator");
            string2 = string2.replaceAll("[\\r]{0,1}\\n", string3) + string3;
            this.folderUtils.createParentIfNecessary(file);
            this.io.writeStringToFile(string2, file, 0L, 420, new IOObserver[0]);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean writeStringToLicenseFileAndElevateIfNecessary(String string, File file) {
        File file2;
        boolean bl = this.writeStringToLicenseFile(string, file);
        if (!bl && this.writeStringToLicenseFile(string, file2 = new File(System.getProperty("java.io.tmpdir"), file.getName().concat(".tmp")))) {
            bl = this.io.cpFileAsRoot(file2.getAbsolutePath(), file.getAbsolutePath());
        }
        return bl;
    }

    @Override
    public boolean deleteLicenseFile(File file) {
        try {
            FileIO.deleteSingleFile((File)file, (Logger)this.fView.getLogger(), (InstUtilResourceBundle)this.fView.getResources());
        }
        catch (Exception exception) {
            String string = this.fView.intlString("error.cannotdeletefile.msg");
            string = MessageFormat.format(string, file.getAbsolutePath());
            this.fView.logWarning(string);
        }
        return !file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCanWrite(File file) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    @Override
    public String getDeactivationString(License license) throws Exception {
        String string = this.fView.intlString("passcodeversion.text");
        try {
            String string2 = license.getLicenseNumber();
            Collection<String> collection = license.getLockingStrings();
            String string3 = this.fMachine.getMatchingLockingString(collection.toArray(new String[collection.size()]));
            if (!string2.equals("STUDENT")) {
                int n = Integer.parseInt(string2);
                string2 = String.format("%010d", n);
                ChangeIt changeIt = new ChangeIt(string2 + string3);
                return string + changeIt.changeString(ChangeIt.OpType.ENCODE);
            }
            ChangeIt changeIt = new ChangeIt(string3);
            return string + "PPPSTUDENT" + changeIt.changeString(ChangeIt.OpType.ENCODE);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Unable to create deactivation string for license number " + license.getLicenseNumber());
        }
    }

    @Override
    public String getPrefString(License license) {
        MWAMachineAttribute[] mWAMachineAttributeArray = this.fMachine.getMachineAttributes();
        StringBuilder stringBuilder = new StringBuilder();
        for (MWAMachineAttribute mWAMachineAttribute : mWAMachineAttributeArray) {
            stringBuilder.append(mWAMachineAttribute.getValue());
        }
        String string = license.getLicenseNumber();
        return PREFIX + stringBuilder + string;
    }

    @Override
    public boolean copyFile(File file, File file2) {
        return FileIO.copySingleFile((File)file, (File)file2) > -1L;
    }

    @Override
    public boolean canValidate(License license) {
        int n = this.getAndParseLicenseNumber(license);
        return n > 0 && !license.isNetworkLicense();
    }

    @Override
    public boolean canRefresh(License license) {
        int n = this.getAndParseLicenseNumber(license);
        return (n > 0 || license.getEntitlementId() > 0) && !license.isNetworkLicense() && license.getLicenseStatus().isActionable();
    }

    @Override
    public boolean canDeactivate(License license) {
        int n = this.getAndParseLicenseNumber(license);
        return n > 0 && !license.isNetworkLicense() && license.getLicenseStatus().isActionable();
    }

    private int getAndParseLicenseNumber(License license) {
        int n;
        String string = license.getLicenseNumber();
        if (string.equals("STUDENT")) {
            n = 1;
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public File getCurrentLicenseFile(final License license) {
        LicenseInfoAdapter licenseInfoAdapter = new LicenseInfoAdapter(){

            public String getLicenseNumber() {
                return license.getLicenseNumber();
            }

            public int getEntitlementId() {
                return license.getEntitlementId();
            }

            public int getPasscodeVersion() {
                return VRDModelImpl.this.fView.getPasscodeVersion();
            }
        };
        LicenseLocationFactoryImpl licenseLocationFactoryImpl = new LicenseLocationFactoryImpl();
        Collection collection = this.fFinder.findCurrentLicenseFiles((LicenseLocationFactory)licenseLocationFactoryImpl);
        for (File file : collection) {
            if (!this.fFilter.filterLicenseFile(file, (LicenseInfo)licenseInfoAdapter, this.fUserLoginName, this.fMachine)) continue;
            return file;
        }
        return null;
    }

    @Override
    public Collection<File> getAllLicenseFiles(License license) throws InterruptedException {
        GetAllLicenseFilesWorker getAllLicenseFilesWorker = new GetAllLicenseFilesWorker(this.fView, this.fMachine, this.fFinder, this.fFilter, license);
        getAllLicenseFilesWorker.startAndWait();
        if (getAllLicenseFilesWorker.isCancelled()) {
            throw new InterruptedException();
        }
        return getAllLicenseFilesWorker.getAllLicenseFiles();
    }

    @Override
    public Service getService() {
        return this.fService;
    }

    private static class GetAllLicenseFilesWorker
    extends AbstractServiceThread {
        private Collection<File> fAllFilesForLicense;
        private final Machine fMachine;
        private final LicenseFileFinder fFinder;
        private final LicenseFileFilter fFilter;
        private final License fLicense;

        GetAllLicenseFilesWorker(VRDView vRDView, Machine machine, LicenseFileFinder licenseFileFinder, LicenseFileFilter licenseFileFilter, License license) {
            super((ServiceThreadView)vRDView, "dialog.findall.title", "dialog.findall", false);
            this.fMachine = machine;
            this.fFinder = licenseFileFinder;
            this.fFilter = licenseFileFilter;
            this.fLicense = license;
        }

        public void run() {
            this.fAllFilesForLicense = new ArrayList<File>();
            LicenseInfoAdapter licenseInfoAdapter = new LicenseInfoAdapter(){

                public String getLicenseNumber() {
                    return GetAllLicenseFilesWorker.this.fLicense.getLicenseNumber();
                }

                public ActivationType getActivationType() {
                    return GetAllLicenseFilesWorker.this.fLicense.getActivationType();
                }
            };
            LicenseLocationFactoryImpl licenseLocationFactoryImpl = new LicenseLocationFactoryImpl();
            Collection collection = this.fFinder.findAllLicenseFiles((LicenseLocationFactory)licenseLocationFactoryImpl);
            for (File file : collection) {
                if (!this.fFilter.filterLicenseFile(file, (LicenseInfo)licenseInfoAdapter, "", this.fMachine)) continue;
                this.fAllFilesForLicense.add(file);
            }
            this.finish();
        }

        public Collection<File> getAllLicenseFiles() {
            return Collections.unmodifiableCollection(this.fAllFilesForLicense);
        }
    }
}

