/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.license;

import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.ActivationType;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.vrd.license.LicenseFileFilter;
import java.io.File;
import java.util.Collection;

public class LicenseFileFilterImpl
implements LicenseFileFilter {
    private final LicenseFileParser fParser;

    public LicenseFileFilterImpl(LicenseFileParser licenseFileParser) {
        this.fParser = licenseFileParser;
    }

    @Override
    public boolean filterLicenseInfoCollection(Collection<LicenseInfo> collection, LicenseInfo licenseInfo, String string, Machine machine) {
        String string2 = licenseInfo.getFeatureName();
        String string3 = licenseInfo.getLicenseNumber();
        int n = licenseInfo.getEntitlementId();
        String string4 = licenseInfo.getEncryptionKey();
        int n2 = licenseInfo.getPasscodeVersion();
        boolean bl = false;
        for (LicenseInfo licenseInfo2 : collection) {
            bl = true;
            if (!string2.equals("") && !string2.equalsIgnoreCase(licenseInfo2.getFeatureName())) {
                bl = false;
                continue;
            }
            if (!string3.equals("") && !string3.equalsIgnoreCase(licenseInfo2.getLicenseNumber())) {
                bl = false;
                continue;
            }
            if (n > 0 && n != licenseInfo2.getEntitlementId()) {
                bl = false;
                continue;
            }
            if (!string4.equals("") && !string4.equalsIgnoreCase(licenseInfo2.getEncryptionKey())) {
                bl = false;
                continue;
            }
            if (n2 > 0 && n2 != licenseInfo2.getPasscodeVersion()) {
                bl = false;
                continue;
            }
            if (!string.equals("") && licenseInfo2.isSNULicense() && !licenseInfo2.isLockedToUserLoginName(string)) {
                bl = false;
                continue;
            }
            if (machine != null && !licenseInfo2.isLockedToMachine(machine)) {
                bl = false;
                continue;
            }
            if (licenseInfo.getActivationType() == ActivationType.UNRECOGNIZED || licenseInfo2.getActivationType() == licenseInfo.getActivationType()) break;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean filterLicenseFile(File file, LicenseInfo licenseInfo, String string, Machine machine) {
        return this.filterLicenseInfoCollection(this.fParser.parseLicenseFile(file), licenseInfo, string, machine);
    }
}

