/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.vrd.command;

import com.mathworks.vrd.command.ValidateCommand;
import com.mathworks.vrd.command.ValidateStatus;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseStatus;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.VRDView;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

class ValidateCommandInternal
implements ValidateCommand {
    private static Map<Integer, ValidateStatus> sInt2StatusMap = new HashMap<Integer, ValidateStatus>();
    private final VRDModel fModel;
    private static final int DEACTIVATION_PERIODICITY = 1;
    private final VRDView fView;
    private final boolean fAlwaysValidate;

    ValidateCommandInternal(VRDModel vRDModel, VRDView vRDView, boolean bl) {
        this.fModel = vRDModel;
        this.fView = vRDView;
        this.fAlwaysValidate = bl;
    }

    @Override
    public ValidateStatus validate(License license) {
        String string = license.getLicenseString();
        this.fView.logInfo("Starting license validation on license " + string);
        boolean bl = ValidateCommandInternal.isValidateEnabled(license);
        if (this.fAlwaysValidate || bl) {
            boolean bl2 = this.isTimeForNextValidation(license);
            if (this.fAlwaysValidate || bl2) {
                try {
                    boolean bl3 = this.isInternetAvailable();
                    if (bl3) {
                        ValidateStatus validateStatus = this.sendValidateRequest(license);
                        if (validateStatus == ValidateStatus.UP_TO_DATE || validateStatus == ValidateStatus.REFRESH_REQUIRED || validateStatus == ValidateStatus.DEACTIVATE_REQUIRED) {
                            this.resetTimeToNextValidation(TimeType.DEFAULT, license);
                            if (validateStatus == ValidateStatus.UP_TO_DATE) {
                                this.fView.logInfo("License is up-to-date");
                                return validateStatus;
                            }
                            if (validateStatus == ValidateStatus.REFRESH_REQUIRED) {
                                license.setLicenseStatus(LicenseStatus.UPDATE_REQUIRED);
                                this.fView.logInfo("Update required on license");
                                return validateStatus;
                            }
                            license.setLicenseStatus(LicenseStatus.DEACTIVATE_REQUIRED);
                            this.resetTimeToNextValidation(TimeType.DAILY, license);
                            this.fView.logInfo("Deactivation required on license");
                            return validateStatus;
                        }
                        this.fView.logInfo("Error returned from the MathWorks when validating license");
                        return ValidateStatus.VALIDATE_ERROR;
                    }
                    this.fView.logInfo("Cannot connect to the MathWorks to validate license");
                    return ValidateStatus.CANNOT_CONNECT;
                }
                catch (InterruptedException interruptedException) {
                    return ValidateStatus.CANCELLED;
                }
            }
            this.fView.logInfo("Not time to validate license");
            return ValidateStatus.NOT_TIME_TO_VALIDATE;
        }
        this.fView.logInfo("Validation disabled");
        return ValidateStatus.NOT_VALIDATING;
    }

    private static boolean isValidateEnabled(License license) {
        int n = license.getValidationInterval();
        return n > 0;
    }

    private boolean isTimeForNextValidation(License license) {
        String string = this.fView.getStringPref(this.fModel.getPrefString(license));
        if (string.length() == 0) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        Long l = calendar.getTimeInMillis();
        int n = l.compareTo(new Long(string));
        return n >= 0;
    }

    private boolean isInternetAvailable() throws InterruptedException {
        return this.fModel.connectNow();
    }

    private ValidateStatus sendValidateRequest(License license) throws InterruptedException {
        int n = this.fModel.validate(license);
        return sInt2StatusMap.containsKey(n) ? sInt2StatusMap.get(n) : ValidateStatus.VALIDATE_ERROR;
    }

    private void resetTimeToNextValidation(TimeType timeType, License license) {
        String string = this.fModel.getPrefString(license);
        if (timeType.equals((Object)TimeType.DEFAULT)) {
            int n = license.getValidationInterval();
            this.resetValidationPref(n, string);
        } else {
            int n = 1;
            this.resetValidationPref(n, string);
        }
    }

    private void resetValidationPref(int n, String string) {
        int n2 = n * 24;
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, n2);
        Long l = calendar.getTimeInMillis();
        String string2 = l.toString();
        try {
            this.fView.setStringPref(string, string2);
        }
        catch (Throwable throwable) {
            this.fView.logWarning(this.fView.intlString("pref.write.err"));
        }
    }

    static {
        sInt2StatusMap.put(0, ValidateStatus.UP_TO_DATE);
        sInt2StatusMap.put(1, ValidateStatus.REFRESH_REQUIRED);
        sInt2StatusMap.put(2, ValidateStatus.DEACTIVATE_REQUIRED);
    }

    private static enum TimeType {
        DEFAULT,
        DAILY;

    }
}

