/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.webservices.urlmanager.ReleaseEnv;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

class ReleaseEnvPropertiesFile
implements ReleaseEnv {
    private static final String PROPERTIES_FILE = "com/mathworks/mlwebservices/resources/RES_urlenv_generated_props.properties";
    private static final String RELEASE_PROPERTY = "releasefamily";
    private static final String ENVIRONMENT_PROPERTY = "urlenv";
    private static final String ENVIRONMENT_OVERRIDE_PROPERTY = "WS_ENV";
    private final String matlabRelease;
    private final String environment;

    ReleaseEnvPropertiesFile() {
        Object object;
        Properties properties = new Properties();
        try {
            object = ReleaseEnvPropertiesFile.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Throwable throwable = null;
            try {
                properties.load((InputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new MissingResourceException("Error reading release environment properties file", ReleaseEnvPropertiesFile.class.getSimpleName(), PROPERTIES_FILE);
        }
        this.matlabRelease = properties.getProperty(RELEASE_PROPERTY);
        if (null == this.matlabRelease) {
            throw new MissingResourceException("Properties file must contain property releasefamily", ReleaseEnvPropertiesFile.class.getSimpleName(), RELEASE_PROPERTY);
        }
        object = System.getenv(ENVIRONMENT_OVERRIDE_PROPERTY);
        object = object != null ? object : System.getProperty(ENVIRONMENT_OVERRIDE_PROPERTY);
        this.environment = object = object != null ? object : properties.getProperty(ENVIRONMENT_PROPERTY);
        if (null == this.environment) {
            throw new MissingResourceException("Environment must be set", ReleaseEnvPropertiesFile.class.getSimpleName(), ENVIRONMENT_PROPERTY);
        }
    }

    public String getMatlabRelease() {
        return this.matlabRelease;
    }

    public String getReleaseEnvironment() {
        return this.environment;
    }

    public List<String> getSearchPath() {
        String string = System.getenv("HOME");
        return Arrays.asList(MessageFormat.format("{0}/.matlab/{1}/{2}.properties", string, this.matlabRelease, this.environment));
    }
}

