/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabinstaller;

import com.mathworks.install.AbstractInstallOption;
import com.mathworks.install.AvailableProduct;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.DisplayCommandErrorHandler;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.Product;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.command.PathdefGeneratorCommand;
import com.mathworks.install.condition.ArchConditions;
import com.mathworks.install.condition.Condition;
import com.mathworks.install.condition.ControllingProductCondition;
import com.mathworks.install.exception.ExceptionLevel;
import com.mathworks.install.exception.InstallerRequirementNotSatisfiedException;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.service.ScheduledTaskParameters;
import com.mathworks.install.service.Service;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.installwizard.AbstractMathworksInstallConfiguration;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.matlabinstaller.MatlabFileAssociationsCommand;
import com.mathworks.matlabinstaller.MatlabPreloaderScheduledTaskParameters;
import com.mathworks.matlabinstaller.ProductConditions;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public abstract class AbstractMatlabInstallConfiguration
extends AbstractMathworksInstallConfiguration {
    static final String MW_ASSEMBLY_GROUP_NAME = "MathWorks_Zone";
    private static final int LICENSE_MANAGER = 0;
    private static final int COMPILER = 28;
    private static final int COMPILER_SDK = 97;
    private static final int SIMULINK = 2;
    private static final int STATEFLOW = 38;
    private static final int SIMULINK_CODER = 14;
    private static final int MATLAB_DISTRIBUTED_COMPUTING_SERVER = 94;
    private static final int XPC_TARGET = 56;
    private static final int SIMBIOLOGY = 103;
    private static final int FIXED_POINT_TOOLBOX = 91;
    private static final int MATLAB_CODER = 135;
    private static final int SIMULINK_TEST = 144;
    protected static final String RELEASE_STRING = WizardResourceKeys.RELEASE.getString(new Object[0]);
    private static final String LOCATION_TO_EXECUTABLE_SUBKEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\";
    private static final int[] PRODUCTS_REQUIRING_COMPILER = new int[]{38, 14, 56, 135, 144};
    private static final int[] PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS64 = new int[]{14, 56, 135};
    private static final int[] PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS32 = new int[]{56};
    private static final int[] PRODUCTS_RECOMMENDING_COMPILER = new int[]{103, 91};
    private static final String MATLAB_EXE = "matlab.exe";
    private static final String ACTIVATE_MATLAB_EXE = "activate_matlab.exe";
    private static final String DISTRIBUTED_COMPUTING_LOCATION_IDENTIFIER = "dc";
    private static final String CREATE_ACCEL_TASK = "createAccelTask";
    private static final InstallOption[] NO_INSTALL_OPTIONS = new InstallOption[0];
    private static final String MPS_APPLICATION_NAME = "MATLAB Production Server";
    private static final String MATLAB_APPLICATION_NAME = "MATLAB";
    private static final int MATLAB_PRODUCTION_SERVER = 126;
    private static final String MATLAB_COMMENTS = InstallResourceKeys.MATLAB_SHORTCUT_COMMENTS.getString(new Object[0]);
    private static final String PATH_TO_EXE = "bin";
    private static final String POLYSPACE_BUG_FINDER_EXE = "polyspace-bug-finder.exe";
    private static final String POLYSPACE_BUG_FINDER_COMMENTS = InstallResourceKeys.POLYSPACE_BUG_FINDER_COMMENTS.getString(new Object[0]);
    private static final String POLYSPACE_CODE_PROVER_EXE = "polyspace-code-prover.exe";
    private static final String POLYSPACE_CODE_PROVER_COMMENTS = InstallResourceKeys.POLYSPACE_CODE_PROVER_COMMENTS.getString(new Object[0]);
    private static final String RELATIVE_PATH_TO_POLYSPACE_EXE = "polyspace" + File.separator + "bin";
    private static final String PATH_DEF_M = "pathdef.m";

    public final String getDefaultDirectoryName(Platform platform, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(platform.getArchString(), list)) {
            return MPS_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName());
        }
        return this.getDefaultDirectoryName();
    }

    protected abstract String getDefaultDirectoryName();

    public final Command[] createStartMenuShortcutCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string = platform.getArchString();
        arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE, MATLAB_EXE, this.getDisplayName(string, installerRequirements), this.getStartMenuFolder(string, installerRequirements), RELEASE_STRING, MATLAB_COMMENTS, true));
        arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE, MATLAB_EXE, this.getDisplayName(string, installerRequirements), "", RELEASE_STRING, MATLAB_COMMENTS, true));
        if (!platform.isWindows8OrAbove()) {
            arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE + File.separator + string, ACTIVATE_MATLAB_EXE, InstallResourceKeys.ACTIVATE_MATLAB.getString(new Object[]{RELEASE_STRING}), this.getStartMenuFolder(string, installerRequirements), RELEASE_STRING, "", false));
            arrayList.addAll(Arrays.asList(this.createAdditionalStartMenuShortcutCommands(string, commandFactory, this.getStartMenuFolder(string, installerRequirements))));
        }
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final Command[] createStartMenuShortcutForPolyspaceBFCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        String string = platform.getArchString();
        return new Command[]{commandFactory.createStartMenuShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_BUG_FINDER_EXE, InstallResourceKeys.POLYSPACE_BUG_FINDER_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), this.getStartMenuFolder(string, installerRequirements), RELEASE_STRING, POLYSPACE_BUG_FINDER_COMMENTS, false)};
    }

    public final Command[] createStartMenuShortcutForPolyspaceCPCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        String string = platform.getArchString();
        return new Command[]{commandFactory.createStartMenuShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_CODE_PROVER_EXE, InstallResourceKeys.POLYSPACE_CODE_PROVER_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), this.getStartMenuFolder(string, installerRequirements), RELEASE_STRING, POLYSPACE_CODE_PROVER_COMMENTS, false)};
    }

    private String getDisplayName(String string, InstallerRequirements installerRequirements) {
        return this.add32BitQualifierIfOn64BitMachine(string, InstallResourceKeys.MATLAB_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), installerRequirements);
    }

    protected abstract Command[] createAdditionalStartMenuShortcutCommands(String var1, CommandFactory var2, String var3);

    public final Command[] createDesktopShortcutCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{commandFactory.createDesktopShortcutCommand(PATH_TO_EXE, MATLAB_EXE, this.getDisplayName(string, installerRequirements), RELEASE_STRING, MATLAB_COMMENTS, true)};
    }

    public final Command[] createDesktopShortcutForPolyspaceBFCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{commandFactory.createDesktopShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_BUG_FINDER_EXE, InstallResourceKeys.POLYSPACE_BUG_FINDER_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), RELEASE_STRING, POLYSPACE_BUG_FINDER_COMMENTS, false)};
    }

    public final Command[] createDesktopShortcutForPolyspaceCPCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{commandFactory.createDesktopShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_CODE_PROVER_EXE, InstallResourceKeys.POLYSPACE_CODE_PROVER_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), RELEASE_STRING, POLYSPACE_CODE_PROVER_COMMENTS, false)};
    }

    protected final String getUninstallProgramsEntryVersion(String string, Collection<? extends Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return InstutilResourceKeys.MPSVERSION.getString(new Object[0]);
        }
        return InstutilResourceKeys.MATLABVERSION.getString(new Object[0]);
    }

    protected final String getUninstallProgramsEntryDisplayName(String string, Collection<Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return InstallResourceKeys.MPS_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
        }
        return InstallResourceKeys.MATLAB_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
    }

    public final String[] getSetupNotes(File file, InstallOption[] installOptionArray, HyperlinkProvider hyperlinkProvider, String string, Installer installer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AvailableProduct[] availableProductArray = installer.getSelectedAvailableProducts();
        this.addWin32NotSupportedNote(arrayList, string, availableProductArray);
        this.addCustomNotes(arrayList, installer, file);
        this.addLicenseManagerNote(file, string, availableProductArray, installOptionArray, arrayList);
        AbstractMatlabInstallConfiguration.addCompilerRequiredNote(availableProductArray, arrayList, string);
        this.addSimulinkNote(availableProductArray, arrayList, string);
        AbstractMatlabInstallConfiguration.addCompilerRecommendedNote(availableProductArray, arrayList, string);
        AbstractMatlabInstallConfiguration.addMDCSNote(availableProductArray, arrayList, hyperlinkProvider);
        AbstractMatlabInstallConfiguration.addMPSNote(availableProductArray, file, arrayList, string);
        AbstractMatlabInstallConfiguration.addMatlabCompilerNotes(availableProductArray, arrayList, string);
        AbstractMatlabInstallConfiguration.addMatlabCompilerSDKNotes(availableProductArray, arrayList, string);
        this.addTopLabel(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void addCustomNotes(Collection<String> collection, Installer installer, File file) {
    }

    protected void addTopLabel(Collection<String> collection) {
        if (!collection.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(WizardResourceKeys.SETUP_LABEL_TOP.getString(new Object[0]));
            arrayList.addAll(collection);
            collection.clear();
            collection.addAll(arrayList);
        }
    }

    public final String getInstallationPath(String string) {
        return string;
    }

    public final String getDefaultInstallationDirectory(Platform platform, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(platform.getArchString(), list)) {
            return MATLAB_APPLICATION_NAME.concat(File.separator).concat(MPS_APPLICATION_NAME).replaceAll(" ", "_").concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        if (platform.isLinux()) {
            return MATLAB_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        return "MATLAB_".concat(this.getDefaultDirectoryName().replaceAll(" ", "_")).concat(".app");
    }

    public final void deactivateInstallation(String string, Product[] productArray, String[] stringArray) {
        List<Product> list = Arrays.asList(productArray);
        if (new ControllingProductCondition().isSatisfied(string, list) && !ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            this.deactivateInstallation(stringArray);
        }
    }

    public final String getUsageId(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            return "mps_" + this.getUsageId();
        }
        return this.getUsageId();
    }

    protected abstract String getUsageId();

    public final String getUsageString(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            return this.getUsageString(MPS_APPLICATION_NAME);
        }
        return this.getUsageString();
    }

    protected abstract String getUsageString(String var1);

    protected abstract String getUsageString();

    protected abstract void deactivateInstallation(String[] var1);

    public final Command[] getAdditionalPostUninstallCommands(String string, Product[] productArray, CommandFactory commandFactory, final IO iO) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(new Command(){

            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
            }

            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
                new PathdefGeneratorCommand(iO, file.getAbsolutePath(), AbstractMatlabInstallConfiguration.PATH_DEF_M).undo(string, file, installFlowControlHandler);
            }
        });
        arrayList.add(commandFactory.createSharedDocCommand());
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final boolean shouldAllowFolderChangeIfAlreadyInstalled(Platform platform) {
        return true;
    }

    public final boolean canChooseTypicalOrCustom() {
        return true;
    }

    public final boolean canChangeFolder(Platform platform, Registry registry, Installer installer) {
        return true;
    }

    public final InstallOption[] getUninstallOptions(String string, Product[] productArray, InstallOption ... installOptionArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            return NO_INSTALL_OPTIONS;
        }
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>(Arrays.asList(installOptionArray));
        arrayList.add((InstallOption)new AbstractInstallOption(null, true, InstallOptionType.CUSTOM){

            public Command[] getCommands(CommandFactory commandFactory, ServiceFactory serviceFactory) {
                return new Command[]{commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters())})};
            }
        });
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    protected final String getPathToRegister(String string) {
        return string;
    }

    protected final void checkAdditionalInstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        this.checkAdditionalMatlabInstallerRequirements(installerRequirements);
    }

    protected abstract void checkAdditionalMatlabInstallerRequirements(InstallerRequirements var1) throws InstallerRequirementNotSatisfiedException;

    protected final void checkAdditionalUninstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        if (installerRequirements.anyMatlabRunning()) {
            throw new InstallerRequirementNotSatisfiedException(ExceptionLevel.ERROR, ResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]), ResourceKeys.SHUTDOWN_MATLAB_TEXT.getString(new Object[0]));
        }
    }

    protected final String getApplicationVersion(String string, Collection<? extends Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return InstutilResourceKeys.MPSVERSION.getString(new Object[0]);
        }
        return InstutilResourceKeys.MATLABVERSION.getString(new Object[0]);
    }

    public final Command[] getPreInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        this.addDistributedComputingToolboxPreInstall(string, list, arrayList, commandFactory, serviceFactory);
        this.addLicenseManagerPreInstall(string, list, arrayList, commandFactory, serviceFactory);
        this.addMATLABDistributedComputingEnginePreInstall(string, list, arrayList, commandFactory, serviceFactory);
        AbstractMatlabInstallConfiguration.addStopMatlabPreloaderCommand(commandFactory, serviceFactory, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    protected final Command[] getAdditionalPostInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory, IO iO, Properties properties) {
        String string2 = AbstractMatlabInstallConfiguration.buildPath(PATH_TO_EXE, string);
        String string3 = AbstractMatlabInstallConfiguration.buildPath("runtime", string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string2);
        ArrayList<Command> arrayList3 = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        this.addDataAcquisitionToolbox(string, list, arrayList3, commandFactory, arrayList2);
        this.addDistributedComputingToolboxPostInstall(string, list, arrayList3, commandFactory);
        this.addCompilerSDK(string, list, arrayList3, commandFactory, string2, arrayList);
        this.addGaugesBlockset(string, list, arrayList3, commandFactory);
        this.addMATLAB(string, list, arrayList3, commandFactory, arrayList2);
        this.addMATLABCompiler(string, list, arrayList3, commandFactory, string3, string2, arrayList);
        this.addMATLABDistributedComputingEnginePostInstall(string, list, arrayList3, commandFactory);
        this.addSimulinkVerificationAndValidation(string, list, arrayList3, commandFactory);
        this.addPolyspaceBugFinder(string, list, arrayList3, commandFactory);
        AbstractMatlabInstallConfiguration.addInstallMatlabPreloaderCommand(string, list, arrayList3, commandFactory, serviceFactory, properties);
        AbstractMatlabInstallConfiguration.addPathdefGeneratorCommand(iO, arrayList3);
        AbstractMatlabInstallConfiguration.addFileAssociationsCommand(productArray, arrayList3, commandFactory, properties);
        arrayList3.add(commandFactory.createSharedDocCommand());
        arrayList3.addAll(Arrays.asList(this.getAdditionalPostInstallCommands(string, list.toArray(new Product[list.size()]), iO, properties, commandFactory)));
        return arrayList3.toArray(new Command[arrayList3.size()]);
    }

    protected final String getUninstallProgramsEntryName(String string, Collection<Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return this.getUninstallProgramsEntryName(MPS_APPLICATION_NAME);
        }
        return this.getUninstallProgramsEntryName("Matlab");
    }

    protected abstract String getUninstallProgramsEntryName(String var1);

    private static void addFileAssociationsCommand(Product[] productArray, Collection<Command> collection, CommandFactory commandFactory, Properties properties) {
        collection.add(new MatlabFileAssociationsCommand(commandFactory, productArray, properties));
    }

    private static void addPathdefGeneratorCommand(final IO iO, Collection<Command> collection) {
        collection.add(new Command(){

            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
                new PathdefGeneratorCommand(iO, file.getAbsolutePath(), AbstractMatlabInstallConfiguration.PATH_DEF_M).execute(string, file, installFlowControlHandler);
            }

            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
            }
        });
    }

    protected abstract Command[] getAdditionalPostInstallCommands(String var1, Product[] var2, IO var3, Properties var4, CommandFactory var5);

    public final Command[] createSymbolicLinkCommands(Product[] productArray, String string, InstallOption installOption, CommandFactory commandFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB.isSatisfied(string, list)) {
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "matlab"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mex"));
        }
        if (ProductConditions.MATLAB_COMPILER.isSatisfied(string, list)) {
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mcc"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mbuild"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "deploytool"));
        }
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final boolean alwaysUseDefaultInstallFolderModel(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        return ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list);
    }

    protected final String getLicenseAgreementPath() {
        return ResourceKeys.MATLAB_LICENSE_AGREEMENT.getString(new Object[0]);
    }

    private void addSimulinkVerificationAndValidation(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegister32BitDllsCommand(AbstractMatlabInstallConfiguration.buildPath("toolbox", "slvnv", "reqmgt", "private"), new String[0]), new Condition[]{ProductConditions.SIMULINK_VERIFICATION_AND_VALIDATION});
    }

    private void addMATLABDistributedComputingEnginePostInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterAssemblyFilesCommand(AbstractMatlabInstallConfiguration.buildPath("toolbox", "distcomp", PATH_TO_EXE, string), MW_ASSEMBLY_GROUP_NAME, new String[]{"DotnetUtilities.dll", "PctIpcDotnet.dll", "MdcsService.dll"}), new Condition[]{ProductConditions.MATLAB_DISTRIBUTED_COMPUTING_ENGINE, ArchConditions.WIN64});
    }

    private void addMATLABDistributedComputingEnginePreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createNamedService("mdced"), serviceFactory.createNamedService("mpich2_smpd")}), new Condition[]{ProductConditions.MATLAB_DISTRIBUTED_COMPUTING_ENGINE, ArchConditions.WINDOWS});
    }

    private void addMATLABCompiler(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, String string2, String string3, List<String> list) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(string2, MATLAB_EXE), new Condition[]{ProductConditions.MATLAB_COMPILER});
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsWithPathsCommand(string3, list, new String[]{"mwcomutil.dll", "mwcommgr.dll"}), new Condition[]{ProductConditions.MATLAB_COMPILER});
    }

    private void addMATLAB(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, List<String> list) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsWithPathsCommand(AbstractMatlabInstallConfiguration.buildPath("toolbox", "matlab", "winfun", string), list, new String[0]), new Condition[]{ProductConditions.MATLAB});
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(AbstractMatlabInstallConfiguration.buildPath(PATH_TO_EXE), MATLAB_EXE), new Condition[]{ProductConditions.MATLAB});
        String string2 = PATH_TO_EXE + File.separator + string;
        String string3 = InstutilResourceKeys.MATLABVERSION.getString(new Object[0]);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createOLEAutomationCommand("mlautoregister.dll", string2, string3), new Condition[]{ProductConditions.MATLAB});
    }

    private void addLicenseManagerPreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createStopServicesCommand(new Service[]{serviceFactory.createLicenseManagerService()}), new Condition[]{ProductConditions.LICENSE_MANAGER, ArchConditions.WINDOWS});
    }

    private void addGaugesBlockset(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        String string2 = AbstractMatlabInstallConfiguration.buildPath("toolbox", "gauges", "ocx");
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsCommand(string2, new String[0]), new Condition[]{ProductConditions.GAUGES_BLOCKSET});
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createCopyFilesToSystemDirectoryCommand(string2, new String[]{"config.gms"}), new Condition[]{ProductConditions.GAUGES_BLOCKSET});
    }

    private void addCompilerSDK(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, String string2, List<String> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string3 = AbstractMatlabInstallConfiguration.buildPath("toolbox", "dotnetbuilder", PATH_TO_EXE, string, "v2.0");
        arrayList.add(commandFactory.createInstallAssemblyFilesCommand(string3, new String[]{"MWArray.dll", "WebFiguresService.dll"}));
        arrayList.add(commandFactory.createRegisterAssemblyFolderCommand("DotNetBuilder", string3));
        arrayList.add(commandFactory.createRegisterDllsWithPathsCommand(string2, list, new String[]{"mwcomutil.dll"}));
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createAssemblyFrameworkCommand(InstallResourceKeys.DOT_NET_BUILDER_ERROR_MESSAGE.getString(new Object[0]), (CommandErrorHandler)new DisplayCommandErrorHandler(), arrayList.toArray(new Command[arrayList.size()])), new Condition[]{ProductConditions.MATLAB_COMPILER_SDK});
    }

    private void addDistributedComputingToolboxPostInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterAssemblyFilesCommand(AbstractMatlabInstallConfiguration.buildPath("toolbox", "distcomp", PATH_TO_EXE, string), MW_ASSEMBLY_GROUP_NAME, new String[]{"DotnetUtilities.dll", "HpcServerSoaClient.dll"}), new Condition[]{ProductConditions.DISTRIBUTED_COMPUTING_TOOLBOX, ArchConditions.WIN64});
    }

    private void addDistributedComputingToolboxPreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createNamedService("mpich2_smpd"), serviceFactory.createNamedService("mdced")}), new Condition[]{ProductConditions.DISTRIBUTED_COMPUTING_TOOLBOX});
    }

    private void addDataAcquisitionToolbox(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, List<String> list) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsWithPathsCommand(AbstractMatlabInstallConfiguration.buildPath("toolbox", "daq", "daq", "private"), list, new String[]{"mwwinsound.dll"}), new Condition[]{ProductConditions.DATA_ACQUISITION_TOOLBOX, ArchConditions.WIN32});
    }

    private void addPolyspaceBugFinder(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsCommand(AbstractMatlabInstallConfiguration.buildPath("polyspace", "plugin", "msvc"), new String[]{"VSUserControlHost.dll"}), new Condition[]{ProductConditions.POLYSPACE_BUG_FINDER});
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(AbstractMatlabInstallConfiguration.buildPath("polyspace", PATH_TO_EXE), POLYSPACE_BUG_FINDER_EXE), new Condition[]{ProductConditions.POLYSPACE_BUG_FINDER});
    }

    private static void addStopMatlabPreloaderCommand(CommandFactory commandFactory, ServiceFactory serviceFactory, Collection<Command> collection) {
        Service service = serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters());
        collection.add(commandFactory.createStopServicesCommand(new Service[]{service}));
    }

    private static void addInstallMatlabPreloaderCommand(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory, Properties properties) {
        Service service = serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters());
        Command command = commandFactory.createInstallServicesCommand(new Service[]{service});
        if (ProductConditions.MATLAB.isSatisfied(string, collection) && !ProductConditions.MATLAB_DISTRIBUTED_COMPUTING_ENGINE.isSatisfied(string, collection) && Boolean.valueOf(properties.getProperty(CREATE_ACCEL_TASK, "true")).booleanValue()) {
            collection2.add(command);
        }
    }

    private static String buildPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(File.separator);
        }
        return stringBuilder.toString();
    }

    private static void addCompilerRequiredNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WIN64.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallConfiguration.addCompilerNote(availableProductArray, ResourceKeys.SETUP_COMPILER_REQUIRED, PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS64, collection, string, ArchConditions.WIN32);
        } else if (ArchConditions.WIN32.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallConfiguration.addCompilerNote(availableProductArray, ResourceKeys.SETUP_COMPILER_REQUIRED, PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS32, collection, string, ArchConditions.WIN64);
        } else {
            AbstractMatlabInstallConfiguration.addCompilerNote(availableProductArray, ResourceKeys.SETUP_COMPILER_REQUIRED, PRODUCTS_REQUIRING_COMPILER, collection, string, ArchConditions.WIN32);
        }
    }

    private static void addMatlabCompilerNotes(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WINDOWS.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallConfiguration.getNotesWithProductInfo(availableProductArray, collection, 28, ResourceKeys.SETUP_COMPILER_WIN);
        }
    }

    private static void addMatlabCompilerSDKNotes(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WINDOWS.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallConfiguration.getNotesWithProductInfo(availableProductArray, collection, 97, ResourceKeys.SETUP_COMPILER_SDK_WIN);
        } else {
            AbstractMatlabInstallConfiguration.getNotesWithProductInfo(availableProductArray, collection, 97, ResourceKeys.SETUP_COMPILER_SDK_GLNX64);
        }
    }

    private static void getNotesWithProductInfo(AvailableProduct[] availableProductArray, Collection<String> collection, int n, ResourceKeys resourceKeys) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AvailableProduct availableProduct : availableProductArray) {
            if (!availableProduct.canInstall() || availableProduct.getProductNumber() != n) continue;
            stringBuilder.append(availableProduct.getName()).append(' ').append(availableProduct.getVersion());
            AbstractMatlabInstallConfiguration.addNote(collection, resourceKeys.getString(new Object[]{collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallConfiguration.getCompilerLink(), stringBuilder.toString()}), new String[0]);
        }
    }

    private static void addCompilerRecommendedNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        AbstractMatlabInstallConfiguration.addCompilerNote(availableProductArray, ResourceKeys.SETUP_COMPILER_RECOMMENDED, PRODUCTS_RECOMMENDING_COMPILER, collection, string, ArchConditions.WINDOWS);
    }

    private static void addCompilerNote(AvailableProduct[] availableProductArray, ResourceKeys resourceKeys, int[] nArray, Collection<String> collection, String string, ArchConditions archConditions) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            for (AvailableProduct availableProduct : availableProductArray) {
                if (!AbstractMatlabInstallConfiguration.productWasInstalledAndMatchesProductNumber(n, availableProduct) || archConditions.isSatisfied(string, Arrays.asList(availableProductArray))) continue;
                stringBuilder.append("<br>").append(availableProduct.getName()).append(' ').append(availableProduct.getVersion());
                bl = true;
            }
        }
        if (bl) {
            AbstractMatlabInstallConfiguration.addNote(collection, resourceKeys.getString(new Object[]{collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallConfiguration.getCompilerLink(), stringBuilder.toString()}), new String[0]);
        }
    }

    private void addSimulinkNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (!ArchConditions.WINDOWS.isSatisfied(string, Arrays.asList(availableProductArray)) && AbstractMatlabInstallConfiguration.containsProduct(availableProductArray, 2)) {
            for (String string2 : this.getSimulinkNotes(collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallConfiguration.getCompilerLink())) {
                AbstractMatlabInstallConfiguration.addNote(collection, string2, new String[0]);
            }
        }
    }

    protected abstract String[] getSimulinkNotes(int var1, String var2, String var3);

    private static void addMDCSNote(AvailableProduct[] availableProductArray, Collection<String> collection, HyperlinkProvider hyperlinkProvider) {
        if (AbstractMatlabInstallConfiguration.containsProduct(availableProductArray, 94)) {
            AbstractMatlabInstallConfiguration.addNote(collection, ResourceKeys.SETUP_MDCE.getString(new Object[0]), hyperlinkProvider.getCustomLink(DISTRIBUTED_COMPUTING_LOCATION_IDENTIFIER));
        }
    }

    private static void addMPSNote(AvailableProduct[] availableProductArray, File file, Collection<String> collection, String string) {
        if (AbstractMatlabInstallConfiguration.containsProduct(availableProductArray, 126)) {
            AbstractMatlabInstallConfiguration.addNote(collection, ResourceKeys.SETUP_MPS.getString(new Object[0]), file.getAbsolutePath() + File.separator, RELEASE_STRING, string);
        }
    }

    private void addLicenseManagerNote(File file, String string, AvailableProduct[] availableProductArray, InstallOption[] installOptionArray, Collection<String> collection) {
        List<AvailableProduct> list = Arrays.asList(availableProductArray);
        if (AbstractMatlabInstallConfiguration.containsProduct(availableProductArray, 0)) {
            String string2 = this.getApplicationName(string, list);
            if (AbstractMatlabInstallConfiguration.licenseManagerServiceSelected(installOptionArray)) {
                AbstractMatlabInstallConfiguration.addNote(collection, ResourceKeys.SETUP_LMSERVICE_ARCH.getString(new Object[0]), string2, file.getAbsolutePath());
            } else {
                AbstractMatlabInstallConfiguration.addNote(collection, ResourceKeys.SETUP_LMFILES_ARCH.getString(new Object[0]), string2, file.getAbsolutePath());
            }
        }
    }

    protected void addWin32NotSupportedNote(Collection<String> collection, String string, AvailableProduct[] availableProductArray) {
        if (ArchConditions.WIN32.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallConfiguration.addNote(collection, ResourceKeys.WIN32_NOT_SUPPORTED.getString(new Object[0]), RELEASE_STRING);
        }
    }

    private static boolean licenseManagerServiceSelected(InstallOption[] installOptionArray) {
        for (InstallOption installOption : installOptionArray) {
            if (!InstallOptionType.LICENSE_SERVICE.equals((Object)installOption.getType()) || !installOption.isSelected()) continue;
            return true;
        }
        return false;
    }

    private static String getCompilerLink() {
        return ResourceKeys.SETUP_COMPILER_ARCH.getString(new Object[0]);
    }

    private static boolean containsProduct(AvailableProduct[] availableProductArray, int n) {
        for (AvailableProduct availableProduct : availableProductArray) {
            if (!AbstractMatlabInstallConfiguration.productWasInstalledAndMatchesProductNumber(n, availableProduct)) continue;
            return true;
        }
        return false;
    }

    private static boolean productWasInstalledAndMatchesProductNumber(int n, AvailableProduct availableProduct) {
        return availableProduct.canInstall() && availableProduct.getProductNumber() == n;
    }

    protected static void addNote(Collection<String> collection, String string, String ... stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(collection.size() + 1);
        arrayList.addAll(Arrays.asList(stringArray));
        collection.add(MessageFormat.format(string, arrayList.toArray()));
    }

    private String getStartMenuFolder(String string, InstallerRequirements installerRequirements) {
        String string2 = MATLAB_APPLICATION_NAME + File.separator + this.getReleaseAndVersionString();
        return this.add32BitQualifierIfOn64BitMachine(string, string2, installerRequirements);
    }

    protected abstract String getReleaseAndVersionString();

    public final boolean requiresLicenseAgreement() {
        return true;
    }

    protected final String getApplicationName(String string, Collection<? extends Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return MPS_APPLICATION_NAME;
        }
        return MATLAB_APPLICATION_NAME;
    }

    protected final void addAdditionalRegisterApplicationCommands(String string, CommandFactory commandFactory, Collection<Command> collection, Collection<Product> collection2) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection2, collection, commandFactory.createRegisterApplicationCommand(new RegisterAppPath(){

            public String getSubKey(String string) {
                return AbstractMatlabInstallConfiguration.getExeKey(AbstractMatlabInstallConfiguration.getFullPathToExe(new File(string)));
            }

            public String getName() {
                return "";
            }

            public String getKeyVal(String string) {
                return AbstractMatlabInstallConfiguration.getFullPathToExe(new File(string)).getAbsolutePath();
            }
        }), new Condition[]{ProductConditions.MATLAB});
    }

    private static File getFullPathToExe(File file) {
        return new File(new File(file, PATH_TO_EXE), MATLAB_EXE);
    }

    private static String getExeKey(File file) {
        return LOCATION_TO_EXECUTABLE_SUBKEY + file.getName();
    }
}

