/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.deactivation;

import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.LicenseFileFinder;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.instutil.licensefiles.LicenseInfoAdapter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseFactory;
import com.mathworks.vrd.license.LicenseFileFilter;
import com.mathworks.vrd.license.LicenseUtil;
import com.mathworks.vrd.model.VRDModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

final class SearchLicenseFactory
implements LicenseFactory {
    private final VRDModel fModel;
    private final Machine fMachine;
    private final LicenseFileFinder fFinder;
    private final LicenseFileParser fParser;
    private final LicenseFileFilter fFilter;

    SearchLicenseFactory(VRDModel vRDModel, Machine machine, LicenseFileFinder licenseFileFinder, LicenseFileParser licenseFileParser, LicenseFileFilter licenseFileFilter) {
        this.fModel = vRDModel;
        this.fMachine = machine;
        this.fParser = licenseFileParser;
        this.fFinder = licenseFileFinder;
        this.fFilter = licenseFileFilter;
    }

    public Collection<License> createLicenseList() {
        LicenseLocationFactoryImpl licenseLocationFactoryImpl = new LicenseLocationFactoryImpl();
        Collection collection = this.fFinder.findAllLicenseFiles((LicenseLocationFactory)licenseLocationFactoryImpl);
        LicenseInfoAdapter licenseInfoAdapter = new LicenseInfoAdapter();
        ArrayList<License> arrayList = new ArrayList<License>();
        for (Object object : collection) {
            Collection collection2 = this.fParser.parseLicenseFile((File)object);
            if (!this.fFilter.filterLicenseInfoCollection(collection2, (LicenseInfo)licenseInfoAdapter, "", this.fMachine) || collection2.isEmpty()) continue;
            LicenseInfo licenseInfo = (LicenseInfo)collection2.iterator().next();
            String string = licenseInfo.getLicenseNumber();
            boolean bl = false;
            for (License license : arrayList) {
                if (!license.getLicenseNumber().equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (bl) continue;
            License license = LicenseUtil.createLicenseFromInfo((LicenseInfo)licenseInfo);
            arrayList.add(license);
        }
        ArrayList arrayList2 = new ArrayList();
        for (License license : arrayList) {
            if (!this.fModel.canDeactivate(license)) continue;
            arrayList2.add(license);
        }
        return arrayList2;
    }
}

