/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.deactivation;

import com.mathworks.instutil.FontHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.services.ProxyTester;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIOptionPane;
import com.mathworks.instwiz.WIOptionPaneUI;
import com.mathworks.instwiz.actions.PrintAction;
import com.mathworks.instwiz.resources.ComponentName;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.resources.VRDComponentName;
import com.mathworks.vrd.view.VRDView;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.plaf.OptionPaneUI;

final class InstWizardVRDViewAdapter
implements VRDView {
    private static final int PANE_MAX_DLG_WIDTH = 400;
    private static final int PANE_MAX_DLG_HEIGHT = 250;
    private static final int SCROLLPANE_MAX_DLG_HEIGHT = 750;
    private final InstWizardIntf fApp;
    private String fClientKey;
    private int fWidth;
    private int fHeight;
    private boolean fErrorsVisible = true;
    private final String matlabRoot;

    InstWizardVRDViewAdapter(InstWizardIntf instWizardIntf, String string, String string2) {
        this.fApp = instWizardIntf;
        this.fClientKey = string;
        this.matlabRoot = string2;
        FontHandler fontHandler = instWizardIntf.getFontHandler();
        this.fWidth = fontHandler.getSize(400);
        this.fHeight = fontHandler.getSize(250);
    }

    public String getRelease() {
        return this.intlString("releasenum.text");
    }

    public int getPasscodeVersion() {
        int n;
        String string = this.intlString("passcodeversion.text");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public String intlString(String string) {
        return this.fApp.getResources().getString(string);
    }

    public void logStart(String string) {
    }

    public void exit() {
    }

    public void logInfo(String string) {
        this.fApp.logInfo(string);
    }

    public void logWarning(String string) {
        this.fApp.logWarning(string);
    }

    public void logFine(String string) {
        this.fApp.logFine(string);
    }

    public void logSevere(String string) {
        this.fApp.logSevere(string);
    }

    public void serviceCallStarted(ServiceThread serviceThread, String string, String string2) {
        this.fApp.serviceCallStarted(serviceThread, string, string2);
    }

    public void serviceCallRunning() {
        this.fApp.serviceCallRunning();
    }

    public void serviceCallDone() {
        this.fApp.serviceCallDone();
    }

    public void error(String string, String string2) {
        if (this.fErrorsVisible) {
            this.fApp.showPanel(string2, string, 0, -1);
        } else {
            this.fApp.logInfo(string + " - " + string2);
        }
    }

    public void warning(String string, String string2) {
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        this.fApp.uncaughtException(thread, throwable);
    }

    public void exception(Throwable throwable, boolean bl) {
        this.fApp.exception(throwable, bl);
    }

    public void setViewVisible(boolean bl) {
        this.fApp.setVisibleFlag(bl);
    }

    public void setErrorsVisible(boolean bl) {
        this.fErrorsVisible = bl;
    }

    public VRDView.VRDOption confirm(License license, String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = this.fApp.isInteractive() && !this.fApp.isCommandLine() ? (n = this.fApp.showPanel(string2, string, 2, 0, 0)) != 0 : false;
        return !bl2 ? VRDView.VRDOption.CONFIRM : VRDView.VRDOption.CANCEL;
    }

    public void complete(License license, String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        WIEditorPane wIEditorPane = new WIEditorPane(this.fApp, string2);
        wIEditorPane.setName(VRDComponentName.COMPLETE_LABEL.toString());
        wIEditorPane.setPreferredSize(new Dimension(400, 750));
        wIEditorPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane jScrollPane = new JScrollPane((Component)wIEditorPane);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        final WIOptionPane wIOptionPane = new WIOptionPane(this.fApp);
        wIOptionPane.setPreferredSize(new Dimension(this.fWidth, this.fHeight));
        wIOptionPane.setMessage((Object)jScrollPane);
        wIOptionPane.setMessageType(bl ? 2 : -1);
        wIOptionPane.setUI((OptionPaneUI)new WIOptionPaneUI());
        wIOptionPane.setOpaque(false);
        ButtonFactory buttonFactory = this.fApp.getButtonFactory();
        JButton jButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.OK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wIOptionPane.setValue((Object)0);
            }
        }, (ComponentName)VRDComponentName.VRD_OK_BUTTON);
        if (bl2) {
            object = new PrintAction(this.fApp, (Component)wIEditorPane);
            JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.PRINT, (Action)object, (ComponentName)VRDComponentName.PRINT_BUTTON);
            wIOptionPane.setOptions(new Object[]{jButton2, jButton});
            wIOptionPane.setInitialValue((Object)jButton2);
        } else {
            wIOptionPane.setOptions(new Object[]{jButton});
            wIOptionPane.setInitialValue((Object)string3);
        }
        object = this.fApp.createDialog((JOptionPane)wIOptionPane, string);
        ((JDialog)object).getRootPane().setDefaultButton(jButton);
        ((Window)object).setSize(this.fWidth, this.fHeight);
        ((Window)object).pack();
        ((JDialog)object).setDefaultCloseOperation(0);
        ((Dialog)object).setModal(true);
        ((Dialog)object).setVisible(true);
    }

    public String getClientString() {
        return this.intlString(this.fClientKey) + '-' + this.fApp.getResources().getString("releasenum.text");
    }

    public Logger getLogger() {
        return this.fApp.getLogger();
    }

    public void setParent(Window window) {
    }

    public void setClientKey(String string) {
        this.fClientKey = string;
    }

    public ProxyTester getProxyTester() {
        return this.fApp.getProxyTester();
    }

    public InstUtilResourceBundle getResources() {
        return this.fApp.getResources();
    }

    public HyperlinkProvider getHyperlinkProvider() {
        return this.fApp.getHyperlinkProvider();
    }

    public String getMatlabRoot() {
        return this.matlabRoot;
    }

    public String getStringPref(String string) {
        return "";
    }

    public void setStringPref(String string, String string2) {
    }

    public ExecutorService getExecutor() {
        return this.fApp.getExecutor();
    }
}

