/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.deactivation;

import ca.odell.glazedlists.gui.TableFormat;
import com.mathworks.deactivation.LicenseSelectionPanel;
import com.mathworks.deactivation.VRDConfigFactoryExternal;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.services.ProxyTester;
import com.mathworks.instwiz.InstWizard;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIOptionPane;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.instwiz.WIUtilities;
import com.mathworks.mlwebservices.Service;
import com.mathworks.mlwebservices.WSSwingWorker;
import com.mathworks.vrd.VRDLogger;
import com.mathworks.vrd.command.DeactivateCommandFactory;
import com.mathworks.vrd.config.VRDConfig;
import com.mathworks.vrd.license.License;
import com.mathworks.vrd.license.LicenseFactory;
import com.mathworks.vrd.license.LicenseFactoryWorker;
import com.mathworks.vrd.license.LicenseUtil;
import com.mathworks.vrd.model.VRDModel;
import com.mathworks.vrd.view.DefaultLicenseTableFormat;
import com.mathworks.vrd.view.DisplayStatusIfLicensesChange;
import com.mathworks.vrd.view.LicenseList;
import com.mathworks.vrd.view.LicenseTable;
import com.mathworks.vrd.view.VRDView;
import com.mathworks.vrd.view.config.LicenseUIConfig;
import com.mathworks.vrd.view.config.LicenseUIConfigFactory;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Observer;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class Deactivate
extends InstWizard {
    private static final String VRD_CLIENT_IDENTIFIER = "vr";
    private boolean fPrompt = false;
    private MachineInfo fMachineInfo;
    private Service fService;
    private boolean isStandalone = false;

    public static void main(String[] stringArray) {
        Deactivate deactivate = new Deactivate();
        deactivate.run(stringArray);
    }

    private void run(String[] stringArray) {
        String string;
        WIResourceBundle wIResourceBundle = new WIResourceBundle("com.mathworks.vrd.resources.RES_Validate", (InstUtilExceptionHandler)this, this.getArchGui());
        wIResourceBundle.addResource("com.mathworks.vrd.resources.RES_Validate_notranslation");
        this.setResources(wIResourceBundle);
        this.setUpIcon();
        VRDLogger vRDLogger = new VRDLogger("com.mathworks.deactivation.Deactivate", "deactivate");
        this.setLogger((WILogger)vRDLogger);
        String[] stringArray2 = new String[100];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        for (int i = 0; i < stringArray2.length && stringArray2[i] != null; ++i) {
            string = stringArray2[i];
            stringArray2[i] = WIUtilities.replaceEnvVarsWithValues((String)string);
        }
        String string2 = null;
        string = null;
        for (int i = 0; i < stringArray2.length && stringArray2[i] != null && stringArray2[i].startsWith("-"); ++i) {
            if ("-debug".equalsIgnoreCase(stringArray2[i])) {
                this.getLogger().setLevel(stringArray2[++i]);
                continue;
            }
            if ("-aws".equalsIgnoreCase(stringArray2[i])) {
                string = stringArray2[++i];
                continue;
            }
            if ("-root".equalsIgnoreCase(stringArray2[i])) {
                string2 = stringArray2[++i];
                continue;
            }
            if ("-text".equalsIgnoreCase(stringArray[i])) {
                this.setVisible(false);
                this.setCommandLine(true);
                continue;
            }
            if ("-v".equalsIgnoreCase(stringArray[i]) || "-verbose".equalsIgnoreCase(stringArray[i])) {
                this.setVerbose(true);
                continue;
            }
            if ("-log".equalsIgnoreCase(stringArray[i])) {
                vRDLogger.setLogPath(stringArray[++i]);
                continue;
            }
            if ("-license".equalsIgnoreCase(stringArray[i])) {
                ++i;
                continue;
            }
            if ("-prompt".equalsIgnoreCase(stringArray[i])) {
                this.fPrompt = true;
                continue;
            }
            if ("-useSystemProxies".equalsIgnoreCase(stringArray[i])) {
                WebproxyFactory.setUseSystemProxiesEnabled((boolean)Boolean.parseBoolean(stringArray[++i]));
                continue;
            }
            if (!"-isStandalone".equalsIgnoreCase(stringArray[i])) continue;
            ++i;
            this.isStandalone = true;
        }
        if (string2 == null) {
            string2 = Deactivate.getMatlabRootRelativeUninstall();
        }
        String string3 = MachineInfo.getArch().startsWith("win") ? string2 + File.separator + "uninstall" + File.separator + "bin" + File.separator + MachineInfo.getArch() : string2 + File.separator + "bin" + File.separator + MachineInfo.getArch();
        ProxyConfiguration proxyConfiguration = WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)WebproxyFactory.createSystemProxySettings((String)string3));
        this.setupGUI(proxyConfiguration);
        String string4 = this.intlString("log.external.start");
        vRDLogger.start(string4);
        String string5 = wIResourceBundle.getString("log.args");
        for (String string6 : stringArray) {
            string5 = string5.concat(' ' + string6);
        }
        vRDLogger.log(Level.FINE, string5);
        String string7 = this.fPrompt ? "client.string.uninstall" : "client.string.deactivate";
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Deactivate.this.cancel();
                super.windowClosing(windowEvent);
            }
        });
        try {
            String string6;
            VRDConfigFactoryExternal exception = new VRDConfigFactoryExternal(this, string2, string3, string7, string, proxyConfiguration);
            VRDConfig vRDConfig = exception.createConfig();
            string6 = vRDConfig.getView();
            VRDModel vRDModel = vRDConfig.getModel();
            LicenseFactory licenseFactory = vRDConfig.getLicenseFactory();
            this.fMachineInfo = vRDConfig.getMachineInfo();
            this.fService = vRDModel.getService();
            LicenseUIConfig licenseUIConfig = LicenseUIConfigFactory.createDeactivateUIConfig((VRDModel)vRDModel, (VRDView)string6, (DeactivateCommandFactory)vRDConfig.getDeactivateCommandFactory());
            licenseUIConfig.setLicenseStatusVisible(false);
            DefaultLicenseTableFormat defaultLicenseTableFormat = new DefaultLicenseTableFormat((VRDView)string6, licenseUIConfig);
            final LicenseTable licenseTable = new LicenseTable((TableFormat)defaultLicenseTableFormat, licenseUIConfig);
            String string8 = licenseUIConfig.getTitle();
            String string9 = licenseUIConfig.getDescription();
            String string10 = licenseUIConfig.getListTitle();
            DisplayStatusIfLicensesChange displayStatusIfLicensesChange = new DisplayStatusIfLicensesChange((LicenseList)licenseTable, licenseUIConfig);
            Action action = licenseUIConfig.createUIAction((LicenseList)licenseTable, (ActionListener)displayStatusIfLicensesChange);
            LicenseSelectionPanel licenseSelectionPanel = new LicenseSelectionPanel(this, string8, string9, string10, (JTable)licenseTable, action);
            licenseSelectionPanel.flipForwardTo(null);
            this.showGUI();
            LicenseFactoryWorker licenseFactoryWorker = new LicenseFactoryWorker((VRDView)string6, licenseFactory);
            licenseFactoryWorker.startAndWait();
            final Collection collection = LicenseUtil.createObservableLicenses((Collection)licenseFactoryWorker.getLicenseList());
            if (collection.isEmpty()) {
                InstUtilResourceBundle string13 = this.getResources();
                final String string14 = string13.getString("deact.notReq.title");
                if (this.fPrompt) {
                    final String string12 = string13.getString("deact.notReq.msg");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Deactivate.this.showPanel(string12, string14, 1, -1);
                            Deactivate.this.done();
                        }
                    });
                } else {
                    final String string11 = string13.getString("deact.notReq2.msg");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Deactivate.this.showPanel(string11, string14, 1, -1);
                            Deactivate.this.done();
                        }
                    });
                }
            } else {
                if (this.fPrompt) {
                    String string12 = wIResourceBundle.getString("deactivateAfterUninstall.text");
                    String string13 = wIResourceBundle.getString("deactivateAfterUninstall.title");
                    WIOptionPane.show((InstWizardIntf)this, (String)string12, (String)string13, (int)2, (int)-1, (int)0);
                }
                for (String string13 : collection) {
                    string13.addObserver((Observer)displayStatusIfLicensesChange);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (License license : collection) {
                            licenseTable.addLicense(license, licenseTable.isEmpty());
                        }
                        licenseTable.autoSize();
                    }
                });
            }
            this.waitUntilDone();
        }
        catch (Exception exception) {
            this.exception(exception, false);
        }
        this.exit();
    }

    private static String getMatlabRootRelativeUninstall() {
        String string = "";
        try {
            File file = new File("./..");
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected final void exit() {
        int n = 0;
        this.disposeAndCloseLog(n);
        if (this.isStandalone) {
            System.exit(0);
        }
    }

    protected String getHyperlinkClientIdentifier() {
        return VRD_CLIENT_IDENTIFIER;
    }

    public MachineInfo getMachineInfo() {
        return this.fMachineInfo;
    }

    public ProxyTester getProxyTester() {
        return new ProxyTester(){

            public boolean isSuccess() {
                return Deactivate.this.fService.isConnected();
            }

            public void run() {
                Deactivate.this.fService.disconnect();
                WSSwingWorker wSSwingWorker = Deactivate.this.fService.getBindingThread(Deactivate.this.getClientString());
                wSSwingWorker.run();
            }
        };
    }
}

