/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.model.states;

import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.ActivatingFromLicenseFile;
import com.mathworks.activationclient.model.message.ErrorMessage;
import com.mathworks.activationclient.model.message.ValidDataForActivateLicenseFile;
import com.mathworks.activationclient.model.message.ValidDataForOnlineActivateLicenseFile;
import com.mathworks.activationclient.model.states.ActivateState;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.instutil.licensefiles.LicenseUtility;
import com.mathworks.instutil.licensefiles.LicenseUtilityFactory;
import com.mathworks.instutil.licensefiles.MarkerUtility;
import com.mathworks.instutil.licensefiles.MarkerUtilityFactory;
import com.mathworks.mlwebservices.Account;
import java.io.File;
import java.util.Collection;

class ActivateFromLicenseFileState
implements ActivateState,
InstUtilExceptionHandler {
    private final ActivationModel activationModel;
    private final LicenseFileParser licenseFileParser;
    private String licenseString;

    ActivateFromLicenseFileState(ActivationModel activationModel, LicenseFileParser licenseFileParser) {
        this.activationModel = activationModel;
        this.licenseFileParser = licenseFileParser;
    }

    @Override
    public void notifyState() {
        this.activationModel.sendMessage(new ActivatingFromLicenseFile());
    }

    @Override
    public void validate() {
        String string = this.activationModel.getLicenseFile();
        boolean bl = false;
        if (string != null && !"".equalsIgnoreCase(string)) {
            bl = true;
        }
        if (this.activationModel.isActivatingOnline()) {
            this.activationModel.sendMessage(new ValidDataForOnlineActivateLicenseFile(bl));
        } else {
            this.activationModel.sendMessage(new ValidDataForActivateLicenseFile(bl));
        }
    }

    @Override
    public boolean activate() {
        String string = this.activationModel.getLicenseFile();
        File file = new File(string);
        if (file.isDirectory()) {
            String string2 = InstutilResourceKeys.ERROR_LICENSEFILE_FOLDER.getString(new Object[]{string});
            this.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), string2);
            this.licenseString = "";
            return false;
        }
        String string3 = InstallerUtilities.readFileIntoString((String)string, (InstUtilExceptionHandler)this);
        if ("".equals(string3)) {
            InstUtilResourceBundle instUtilResourceBundle = this.activationModel.getResources();
            String string4 = instUtilResourceBundle.getString("error.license.title");
            String string5 = instUtilResourceBundle.getString("error.license");
            this.showErrorMessage(string4, string5);
            this.licenseString = "";
            return false;
        }
        if (string3 == null) {
            this.licenseString = "";
            return false;
        }
        Collection collection = this.licenseFileParser.parseLicenseFile(new File(string));
        for (LicenseInfo licenseInfo : collection) {
            boolean bl;
            if (!(licenseInfo.isNetworkLicense() || licenseInfo.getLockingStrings().isEmpty() || (bl = licenseInfo.isLockedToMachine(this.activationModel.getMachineInfo())))) {
                InstUtilResourceBundle instUtilResourceBundle = this.activationModel.getResources();
                String string6 = instUtilResourceBundle.getString("error.license.title");
                String string7 = instUtilResourceBundle.getString("license.invalid.message");
                this.showErrorMessage(string6, string7);
                this.licenseString = "";
                return false;
            }
            if (!this.activationModel.isActivatingWithLicenseFile() || !licenseInfo.isSNULicense() || licenseInfo.isLockedToUserLoginName(this.activationModel.getUserName())) continue;
            this.activationModel.getOtherAccount().setUserName("ThisIsABogusUserNameUnknownUser");
        }
        this.licenseString = string3;
        return true;
    }

    private void showErrorMessage(String string, String string2) {
        this.activationModel.sendMessage(new ErrorMessage(string, string2));
    }

    public void exception(Throwable throwable) {
        String string = InstutilResourceKeys.ERROR_LICENSEFILE_EXCEPTION.getString(new Object[]{throwable.getMessage()});
        this.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), string);
    }

    public void exception(Throwable throwable, boolean bl) {
        this.exception(throwable);
    }

    @Override
    public Account getAccount() {
        return this.activationModel.getAccount();
    }

    @Override
    public String getLicenseString() {
        return this.licenseString;
    }

    @Override
    public LicenseUtility getLicenseUtility(LicenseFileWriter licenseFileWriter, String string, String string2, Account account) {
        return LicenseUtilityFactory.createLicenseUtilityForOther((LicenseFileWriter)licenseFileWriter, (String)string, (String)string2, (Account)account);
    }

    @Override
    public MarkerUtility getMarkerUtility(LicenseFileWriter licenseFileWriter) {
        return MarkerUtilityFactory.createNoOpMarkerUtility();
    }
}

