/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.DoubleDispatch;
import com.mathworks.activationclient.UnknownMethodHandler;
import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.ActivationModelObserver;
import com.mathworks.activationclient.model.message.ActivationMessage;
import com.mathworks.activationclient.view.PanelControllerInterface;
import com.mathworks.activationclient.view.PanelInterface;
import java.util.LinkedList;
import java.util.List;

public abstract class BasePanelController
implements ActivationModelObserver,
PanelControllerInterface {
    final ActivationModel model;
    final ControllerCommandFactory commandFactory;
    private final ApplicationController controller;
    private final List<ActivationMessage> initMessageQueue = new LinkedList<ActivationMessage>();
    private PanelInterface basePanel;
    private ControllerCommand nextButtonCommand;

    public BasePanelController(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        this.model = activationModel;
        this.controller = applicationController;
        this.commandFactory = controllerCommandFactory;
        this.model.attach(this);
    }

    final void setPanel(PanelInterface panelInterface) {
        this.basePanel = panelInterface;
        while (!this.initMessageQueue.isEmpty()) {
            ActivationMessage activationMessage = this.initMessageQueue.remove(0);
            this.sendMessage(activationMessage);
        }
    }

    @Override
    public final void backButton() {
        this.controller.backPanel();
    }

    @Override
    public final void nextButton() {
        assert (this.nextButtonCommand != null);
        this.nextButtonCommand.execute(this.controller);
    }

    @Override
    public final void sendMessage(ActivationMessage activationMessage) {
        if (null == this.basePanel) {
            this.initMessageQueue.add(activationMessage);
        } else {
            DoubleDispatch.execute(this, activationMessage, new UnknownMethodHandler(){

                @Override
                public void execute(Object object, NoSuchMethodException noSuchMethodException) {
                }
            });
        }
    }

    ControllerCommand getNextButtonCommand() {
        return this.nextButtonCommand;
    }

    List<ActivationMessage> getMessageQueue() {
        return this.initMessageQueue;
    }

    final void setNextButtonCommand(ControllerCommand controllerCommand) {
        this.nextButtonCommand = controllerCommand;
        if (null != this.basePanel) {
            this.basePanel.setNextButtonEnabled(controllerCommand != null);
        }
    }

    @Override
    public final void helpButton() {
        String string = this.getHelpPath();
        this.controller.helpButton(string);
    }

    public final String getRootDir() {
        return this.model.getRootDir();
    }

    abstract String getHelpPath();
}

