/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.ActivatingForOther;
import com.mathworks.activationclient.model.message.ActivatingForSelf;
import com.mathworks.activationclient.model.message.InuSelected;
import com.mathworks.activationclient.model.message.IsLicenseAdmin;
import com.mathworks.activationclient.model.message.LeuData;
import com.mathworks.activationclient.model.message.UserNameRequired;
import com.mathworks.activationclient.model.message.ValidDataForActivateOther;
import com.mathworks.activationclient.model.message.ValidDataForActivateSelf;
import com.mathworks.activationclient.model.message.ValidateDataForInu;
import com.mathworks.activationclient.view.other.ActivateOtherPanel;
import com.mathworks.activationclient.view.other.ActivateOtherPanelController;

public class ActivateOtherPanelControllerImpl
extends BasePanelController
implements ActivateOtherPanelController {
    private ActivateOtherPanel panel;

    public ActivateOtherPanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
    }

    @Override
    public final void setPanel(ActivateOtherPanel activateOtherPanel) {
        assert (null == this.panel);
        this.panel = activateOtherPanel;
        String string = this.model.getUserName();
        this.panel.setUserNameFieldText(string);
        this.model.notifyActivateState();
        super.setPanel(activateOtherPanel);
    }

    @Override
    public void activatingForOther() {
        this.model.activatingForOther();
    }

    @Override
    public void activatingForSelf() {
        this.model.activatingForSelf();
    }

    @Override
    public void setUserNameForSelf(String string) {
        this.model.setUserNameForSelf(string);
    }

    @Override
    public void setFirstNameForOther(String string) {
        this.model.setFirstNameForOther(string);
    }

    @Override
    public void setLastNameForOther(String string) {
        this.model.setLastNameForOther(string);
    }

    @Override
    public void setEmailForOther(String string) {
        this.model.setEmailForOther(string);
    }

    @Override
    public void setUserNameForOther(String string) {
        this.model.setUserNameForOther(string);
    }

    void dispatch(ActivatingForOther activatingForOther) {
        this.panel.setActivatingOther();
    }

    void dispatch(ActivatingForSelf activatingForSelf) {
        this.panel.setActivatingSelf();
    }

    void dispatch(UserNameRequired userNameRequired) {
        this.panel.setUserNameRequired(userNameRequired.getValue());
    }

    void dispatch(IsLicenseAdmin isLicenseAdmin) {
    }

    void dispatch(ValidDataForActivateSelf validDataForActivateSelf) {
        if (validDataForActivateSelf.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createShowConfirmationPanelCommand();
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(ValidDataForActivateOther validDataForActivateOther) {
        if (validDataForActivateOther.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createCreateProfileForOtherCommand();
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(ValidateDataForInu validateDataForInu) {
        if (validateDataForInu.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createShowConfirmationPanelCommand();
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(InuSelected inuSelected) {
        if (inuSelected.getValue()) {
            this.panel.setUserNameRequired(true);
        }
    }

    void dispatch(LeuData leuData) {
        this.panel.setOtherFirstName(leuData.getFirstName());
        this.panel.setOtherLastName(leuData.getLastName());
        this.panel.setOtherEmailAddress(leuData.getEmailAddress());
        this.panel.setOtherUserName("");
    }

    @Override
    String getHelpPath() {
        return "help.other";
    }
}

