/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.command;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.ApplicationView;
import com.mathworks.activationclient.model.ActivationModel;

class CreateProfileForSelf
implements ControllerCommand {
    private final String email;
    private final String retypedEmail;
    private final String password;
    private final String retypedPassword;
    private final String firstName;
    private final String lastName;
    private final String activationKey;

    CreateProfileForSelf(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.email = string;
        this.retypedEmail = string2;
        this.password = string3;
        this.retypedPassword = string4;
        this.firstName = string5;
        this.lastName = string6;
        this.activationKey = string7;
    }

    @Override
    public void execute(ApplicationController applicationController) {
        ActivationModel activationModel = applicationController.getModel();
        boolean bl = true;
        if (!this.email.equalsIgnoreCase(this.retypedEmail)) {
            this.showError(applicationController, "error.email.match");
            bl = false;
        } else if (!this.password.equalsIgnoreCase(this.retypedPassword)) {
            this.showError(applicationController, "error.password.match");
            bl = false;
        } else if (!activationModel.createProfileForSelf(this.email, this.password, this.firstName, this.lastName, this.activationKey)) {
            bl = false;
        }
        if (bl) {
            ControllerCommandFactory controllerCommandFactory = applicationController.getCommandFactory();
            ControllerCommand controllerCommand = activationModel.getAccount().isVerified() ? controllerCommandFactory.createLoginCommand(this.email, this.password, controllerCommandFactory.createValidateEntitlementCommand()) : controllerCommandFactory.createShowEmailVerificationPanel();
            controllerCommand.execute(applicationController);
        }
    }

    private void showError(ApplicationController applicationController, String string) {
        ApplicationView applicationView = applicationController.getApplicationView();
        applicationView.error(applicationView.getResource("error.general.title"), applicationView.getResource(string));
    }
}

