/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient;

import com.mathworks.activationclient.controller.ApplicationView;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.WebServiceCaller;
import com.mathworks.activationclient.model.WebServiceResponse;
import com.mathworks.activationclient.model.WebServiceResponseImpl;
import com.mathworks.activationclient.model.message.DcSelected;
import com.mathworks.activationclient.model.message.SnuSelected;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.mwaws.client.v6.MWAGetPeopleResponse;
import com.mathworks.internal.mwaws.client.v6.MWAMachineAttribute;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.ActivationService;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.LicenseManagementType;
import com.mathworks.mlwebservices.LockingTypeConstants;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.mlwebservices.Service;

class DefaultWebServiceCaller
implements WebServiceCaller {
    private ApplicationView view;
    private ActivationModel model;
    private ActivationService activationService;
    private LoginService loginService;

    DefaultWebServiceCaller(ActivationService activationService, LoginService loginService) {
        this.activationService = activationService;
        this.loginService = loginService;
    }

    @Override
    public ServiceThreadState connectNow(boolean bl) {
        ServiceThreadState serviceThreadState;
        if (!this.activationService.isConnected() || !this.loginService.isConnected()) {
            int n = this.view.getServiceTimeout();
            this.activationService.setBindTimeout(n);
            this.loginService.setBindTimeout(n);
            Service[] serviceArray = new Service[]{this.activationService, this.loginService};
            ServiceThread serviceThread = this.view.getServiceThreadFactory().createBindingThread((ServiceThreadView)this.view, serviceArray, null, bl);
            serviceThread.startAndWait();
            serviceThreadState = serviceThread.getStatus();
        } else {
            serviceThreadState = ServiceThreadState.SUCCESS;
        }
        return serviceThreadState;
    }

    @Override
    public void disconnect() {
        this.activationService.disconnect();
        this.loginService.disconnect();
    }

    @Override
    public void setLoginServiceLocation(String string) {
        this.loginService.setEndpointURL(string);
    }

    @Override
    public ServiceThreadState login(String string, String string2) {
        ServiceThreadState serviceThreadState;
        Account account = this.model.getAccount();
        String string3 = account.getEmailAddress();
        String string4 = account.getPassword();
        String string5 = null;
        if (account.getSecurityToken() == null || !string.equalsIgnoreCase(string3) || !string2.equalsIgnoreCase(string4)) {
            account.clearEntitlements();
            ServiceThread serviceThread = this.view.getServiceThreadFactory().createLoginThread((ServiceThreadView)this.view, this.loginService, string, string2);
            serviceThread.startAndWait();
            serviceThreadState = serviceThread.getStatus();
            if (serviceThreadState == ServiceThreadState.SUCCESS) {
                string5 = (String)serviceThread.getResult();
            }
        } else {
            string5 = account.getSecurityToken();
            serviceThreadState = ServiceThreadState.SUCCESS;
        }
        if (string5 != null && !"".equalsIgnoreCase(string5)) {
            account.setSecurityToken(string5);
            account.setEmailAddress(string);
            account.setPassword(string2);
        }
        return serviceThreadState;
    }

    @Override
    public ServiceThreadState getEntitlements() {
        InstallerEntitlement[] installerEntitlementArray;
        Account account = this.model.getAccount();
        String string = account.getSecurityToken();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createEntitlementListRetrievalThread((ServiceThreadView)this.view, this.activationService, string);
        serviceThread.startAndWait();
        ServiceThreadState serviceThreadState = serviceThread.getStatus();
        if (serviceThreadState == ServiceThreadState.SUCCESS && (installerEntitlementArray = (InstallerEntitlement[])serviceThread.getResult()) != null) {
            for (InstallerEntitlement installerEntitlement : installerEntitlementArray) {
                account.addEntitlement(installerEntitlement);
            }
        }
        return serviceThreadState;
    }

    @Override
    public WebServiceResponse<InstallerEntitlement> getEntitlementByActivationKey(String string) {
        Account account = this.model.getAccount();
        ServiceThreadState serviceThreadState = this.canActivate();
        if (serviceThreadState == ServiceThreadState.SUCCESS) {
            String string2 = account.getSecurityToken();
            ServiceThread serviceThread = this.view.getServiceThreadFactory().createEntitlementByActivationKeyThread((ServiceThreadView)this.view, this.activationService, string2, string);
            serviceThread.startAndWait();
            InstallerEntitlement installerEntitlement = (InstallerEntitlement)serviceThread.getResult();
            InstallerEntitlement installerEntitlement2 = account.getSelectedEntitlement();
            if (installerEntitlement != null) {
                String string3 = installerEntitlement.getId();
                if (installerEntitlement2 == null || installerEntitlement2.getId() == null || string3.equalsIgnoreCase(installerEntitlement2.getId())) {
                    account.setSelectedEntitlement(installerEntitlement);
                    if (installerEntitlement.isNamedUserLicense()) {
                        this.model.sendMessage(new SnuSelected());
                    } else if (installerEntitlement.isComputerBasedLicense()) {
                        this.model.sendMessage(new DcSelected());
                    }
                    installerEntitlement.setActivationKey(string);
                } else {
                    InstUtilResourceBundle instUtilResourceBundle = this.view.getResources();
                    String string4 = instUtilResourceBundle.getString("keyerror.msg");
                    String string5 = instUtilResourceBundle.getString("keyerror.title");
                    this.view.showPanel(string4, string5, 0, -1);
                    return new WebServiceResponseImpl<Object>(ServiceThreadState.FAIL, null);
                }
            }
            return new WebServiceResponseImpl<Object>(serviceThread.getStatus(), serviceThread.getResult());
        }
        return new WebServiceResponseImpl<Object>(serviceThreadState, null);
    }

    @Override
    public ServiceThreadState createProfileForSelf(String string, String string2, String string3, String string4, String string5) {
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createCreateProfileForSelfThread((ServiceThreadView)this.view, this.activationService, string, string2, string3, string4, string5);
        serviceThread.startAndWait();
        Account account = this.model.getAccount();
        account.setSecurityToken(null);
        account.setEmailAddress(string);
        account.setPassword(string2);
        account.setFirstName(string3);
        account.setLastName(string4);
        account.setActivationKey(string5);
        account.setVerified(((Boolean)serviceThread.getResult()).booleanValue());
        return serviceThread.getStatus();
    }

    @Override
    public ServiceThreadState createProfileForOther(String string, String string2, String string3, String string4, String string5) {
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createCreateProfileForOtherThread((ServiceThreadView)this.view, this.activationService, string, string2, string3, string4, string5);
        serviceThread.startAndWait();
        String string6 = (String)serviceThread.getResult();
        if (string6 != null && !"".equalsIgnoreCase(string6)) {
            Account account = this.model.getOtherAccount();
            account.setSecurityToken(string6);
            account.setEmailAddress(string2);
            account.setFirstName(string3);
            account.setLastName(string4);
            account.setActivationKey(string5);
        }
        return serviceThread.getStatus();
    }

    @Override
    public String activateOther() {
        Account account = this.model.getAccount();
        Account account2 = this.model.getOtherAccount();
        MWAMachineAttribute[] mWAMachineAttributeArray = this.model.getMachineAttributes();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createActivateOtherThread((ServiceThreadView)this.view, this.activationService, account, account2, mWAMachineAttributeArray);
        serviceThread.startAndWait();
        return (String)serviceThread.getResult();
    }

    @Override
    public String activateSelf() {
        Account account = this.model.getActivatingAccount();
        MWAMachineAttribute[] mWAMachineAttributeArray = this.model.getMachineAttributes();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createActivateSelfThread((ServiceThreadView)this.view, this.activationService, account, mWAMachineAttributeArray);
        serviceThread.startAndWait();
        return (String)serviceThread.getResult();
    }

    @Override
    public Boolean activateINU(String string) {
        Account account = this.model.getAccount();
        String string2 = account.getSecurityToken();
        String string3 = account.getActivationKey();
        LockingTypeConstants lockingTypeConstants = this.model.getEntitlement().getSelectedLockingType();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createEnableHostedLicenseManagementThread((ServiceThreadView)this.view, this.activationService, string2, string, string3, lockingTypeConstants, LicenseManagementType.ONLINE_BASED);
        serviceThread.startAndWait();
        return (Boolean)serviceThread.getResult();
    }

    @Override
    public String activateAnonymous() {
        Account account = this.model.getActivatingAccount();
        MWAMachineAttribute[] mWAMachineAttributeArray = this.model.getMachineAttributes();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createActivateAnonymousThread((ServiceThreadView)this.view, this.activationService, account, mWAMachineAttributeArray);
        serviceThread.startAndWait();
        return (String)serviceThread.getResult();
    }

    private ServiceThreadState canActivate() {
        Account account = this.model.getAccount();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createCanActivateThread((ServiceThreadView)this.view, this.activationService, account);
        serviceThread.startAndWait();
        return serviceThread.getStatus();
    }

    @Override
    public MWAGetPeopleResponse getPeople() {
        Account account = this.model.getAccount();
        ServiceThread serviceThread = this.view.getServiceThreadFactory().createGetLicensedEndUserThread((ServiceThreadView)this.view, this.activationService, account);
        serviceThread.startAndWait();
        return (MWAGetPeopleResponse)serviceThread.getResult();
    }

    @Override
    public void setActivationServiceLocation(String string) {
        this.activationService.setEndpointURL(string);
    }

    @Override
    public void setWebServiceTrack(String string) {
        this.activationService.setTrack(string);
        this.loginService.setTrack(string);
    }

    @Override
    public void setWebServiceProtocol(String string) {
        this.activationService.setProtocol(string);
        this.loginService.setProtocol(string);
    }

    @Override
    public String getLoginServiceLocation() {
        return this.loginService.getEndpointURL();
    }

    @Override
    public void setModel(ActivationModel activationModel) {
        this.model = activationModel;
    }

    @Override
    public void setView(ApplicationView applicationView) {
        this.view = applicationView;
    }
}

